/***************************************************************************
    file	         : kb_quicktext.cpp
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/


#include	<qapplication.h>

#ifndef		_WIN32
#include	"kb_quicktext.moc"
#else
#include	"kb_quicktext.h"
#endif

/*  KBQuickText								*/
/*  KBQuickText	: Constructor for quick text edit widget		*/
/*  parent	: QWidget *	  : Parent widget			*/
/*  geometry	: QRect		  : Geometry required over parent	*/
/*  text	: const QString & : Initial text			*/
/*  notify	: QObject *	  : Object to be notified of completion	*/
/*  code	: QEvent::Type	  : Code for notification event		*/

KBQuickText::KBQuickText
	(	QWidget		*parent,
		QRect		geometry,
		const QString	&text,
		QObject		*notify,
		QEvent::Type	code
	)
	:
	TKLineEdit	(parent),
	m_notify	(notify),
	m_code		(code),
	m_done		(false)
{
	setGeometry	(geometry)	;
	setText		(text)		;

	connect
	(	this,
		SIGNAL(returnPressed()),
		SLOT  (slotReturn   ())
	)	;

	qApp->installEventFilter (this)	;
}

/*  KBQuickText								*/
/*  focusOutEvent: Trap focus out					*/
/*  e		 : QFocusEvent * : Event				*/
/*  (returns)	 : void		 :					*/

void	KBQuickText::focusOutEvent
	(	QFocusEvent	*e
	)
{
	/* Process the event normally, then act as if the user had hit	*/
	/* enter.							*/
	TKLineEdit::focusOutEvent (e)	;
	slotReturn ()			;
}

/*  KBQuickText								*/
/*  eventFilter	: Local event filter					*/
/*  o		: QObject *	: Object associated with ....		*/
/*  e		: QEvent *	: .... the event			*/
/*  (returns)	: bool		: True if event consumed		*/

bool	KBQuickText::eventFilter
	(	QObject		*o,
		QEvent		*e
	)
{
	/* Look for mouse click events on any other object. We need	*/
	/* this to handle the case where the user clicks on a widget	*/
	/* that is not accepting focus.					*/
	if (o != this)
		switch (e->type())
		{
			case QEvent::MouseButtonPress	:
			case QEvent::MouseButtonRelease	:
			case QEvent::MouseButtonDblClick:
				slotReturn () ;
				break	;

			default	:
				break	;
		}

	return	TKLineEdit::eventFilter (o, e) ;
}

/*  KBQuickText								*/
/*  slotReturn	: Handle return pressed (or any completion)		*/
/*  (returns)	: void		:					*/

void	KBQuickText::slotReturn ()
{
	/* Notify someone that we are done. It is done this way since	*/
	/* we don't want to call the destructor somewhere like this; it	*/
	/* might work or then again ..... The code makes sure only one	*/
	/* event is ever sent.						*/
	if (!m_done)
	{
		qApp->postEvent (m_notify, new QEvent (m_code)) ;
		m_done	= true	;
	}
}

