/***************************************************************************
    file	         : kb_rowmarkdlg.cpp
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#include	<stdarg.h>
#include	<stdlib.h>

#include	<qapplication.h>
#include	<qdialog.h>
#include	<qlistbox.h>
#include	<qmessagebox.h>


#include	"kb_dbinfo.h"
#include	"kb_classes.h"
#include	"kb_type.h"
#include	"kb_value.h"
#include	"kb_rowmark.h"
#include	"kb_rowmarkdlg.h"


/*  KBRowMarkPropDlg							*/
/*  KBRowMarkPropDlg							*/
/*		: Constructor for RowMark values dialog			*/
/*  rowmark	: KBRowMark *	: Parent rowmark			*/
/*  caption	: cchar *	: Dialog box caption			*/
/*  RowMarks	: QList<KBAttr>&: List of all attributes		*/
/*  (returns)	: KBRowMarkDlg	:					*/

KBRowMarkPropDlg::KBRowMarkPropDlg
	(	KBRowMark	*rowmark,
		cchar		*caption,
		QList<KBAttr>	&attribs
	)
	:
	KBPropDlg (rowmark, caption, attribs)
{
}

/*  KBRowMarkPropDlg							*/
/*  ~KBRowMarkPropDlg							*/
/*		: Destructor for RowMark values dialog			*/
/*  (returns)	:		:					*/

KBRowMarkPropDlg::~KBRowMarkPropDlg ()
{
}

/*  KBRowMarkPropDlg							*/
/*  hideProperty: Hide property						*/
/*  attr	: KBAttr *	: Attribute in question			*/
/*  (returns)	: void		:					*/

bool	KBRowMarkPropDlg::hideProperty
	(	KBAttr	*attr
	)
{
	const QString	aName	= attr->getName() ;

	return	(aName == "expr"    ) ||
		(aName == "onenter" ) ||
		(aName == "onleave" ) ||
		(aName == "onset"   ) ||
		(aName == "taborder") ;
}


/*  rowMarkPropDlg: Run properties dialog				*/
/*  rowmark	  : KBRowMark *	  : Parent rowmark			*/
/*  caption	  : cchar *	  : Dialog box caption			*/
/*  RowMarks	  : QList<KBAttr>&: List of all attributes		*/
/*  (returns)	  : bool	  : Success				*/

bool	rowMarkPropDlg
	(	KBRowMark	*rowmark,
		cchar		*caption,
		QList<KBAttr>	&attribs
	)
{
	KBRowMarkPropDlg rDlg (rowmark, caption, attribs) ;
	return	rDlg.exec ()  ;
}

