/***************************************************************************
    file	         : kb_spinbox.h
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#ifndef	_KB_SPINBOX_H
#define	_KB_SPINBOX_H

#include	"libkbase_exports.h"

#include	"kb_classes.h"
#include	"kb_item.h"
#include	"kb_qtspinbox.h"


/*  KBSpinBox								*/
/*  -----------								*/
/*  This class is used to represent a KBaseField element in the XML	*/
/*  form description. Note that it may map onto more than one actual	*/
/*  field.								*/

class	KBSpinBox : public KBItem
{
	KBAttrStr	fgcolor	;	/* Foreground (text) colour	*/
	KBAttrStr	bgcolor	;	/* Background colour		*/
	KBAttrBool	nullOK	;	/* Is empty field OK		*/
	KBAttrBool	morph	;

	KBCtrlSpinBox	*spinbox;

protected :

	virtual	KBControl	*makeCtrl	(uint)	  ;
	virtual	bool		isMorphing	()	  ;

#if	! __KB_RUNTIME
	virtual	bool		propertyDlg	(cchar *) ;
#endif

public	:

	KBSpinBox (KBNode  *, const QDict<QString> &, bool * = 0) ;
	KBSpinBox (KBNode  *, KBSpinBox *) ;
virtual~KBSpinBox () ;

	virtual	KBNode		*replicate	(KBNode *) ;

	void			userChange	(uint) ;

	inline	bool	allowNull ()
	{
		return	nullOK.getBoolValue() ;
	}
}	;


#if	! __KB_RUNTIME
extern	LIBKBASE_API	bool	spinBoxPropDlg
			(	KBSpinBox	*,
				cchar		*,
				QList<KBAttr>	&,
				cchar		* = 0
			)	;
#endif
#endif	// _KB_SPINBOX_H
