/***************************************************************************
    file	         : tkc_listaddrem.cpp
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#ifndef 	_WIN32
#include	"tkc_listaddrem.moc"
#else
#include 	"tkc_listaddrem.h"
#endif


/*  TKCListAddRem							*/
/*  TKCListAddRem: Constructor for list add/remove helper		*/
/*  edit	 : TKLineEdit *	 : Line edit for additions		*/
/*  list	 : QListBox *	 : Current items list box		*/
/*  bAdd	 : QPushButton * : Add entry button			*/
/*  bRemove	 : QPushButton * : Remove entry button			*/
/*  sorted	 : bool		 : List should be sorted		*/
/*  (returns)	 : TKCListAddRem :					*/

TKCListAddRem::TKCListAddRem
	(	TKLineEdit	&edit,
		QListBox	&list,
		QPushButton	&bAdd,
		QPushButton	&bRemove,
		bool		sorted
	)
	:
	m_edit	  (edit),
	m_list	  (list),
	m_bAdd	  (bAdd),
	m_bRemove (bRemove),
	m_sorted  (sorted)
{
	connect	(&m_bAdd,     SIGNAL(clicked()), SLOT(clickAdd   ())) ;
	connect	(&m_bRemove,  SIGNAL(clicked()), SLOT(clickRemove())) ;
	connect (&m_list,     SIGNAL(highlighted(int)),
			      SLOT  (highlighted(int))) ;

	bRemove.setEnabled (false) ;
}

/*  TKCListAddRem							*/
/*  clickAdd	: Handle click of add button				*/
/*  (returns)	: void		:					*/

void	TKCListAddRem::clickAdd ()
{
	if (!m_edit.text().isEmpty())
	{	addToList (m_edit.text()) ;
		m_edit.clear () ;
	}
}

/*  TKCListAddRem							*/
/*  clickRemove	: Handle click of remove button				*/
/*  (returns)	: void		:					*/

void	TKCListAddRem::clickRemove ()
{
	if (m_list.currentItem() >= 0)
	{
		m_edit   .setText    (m_list.currentText()) ;
		m_list   .removeItem (m_list.currentItem()) ;
		m_bRemove.setEnabled (m_list.count() > 0  ) ;
	}
}

/*  TKCListAddRem							*/
/*  highlighted	: Handle highlight of modules list entry		*/
/*  (returns)	: void		:					*/

void	TKCListAddRem::highlighted
	(	int	index
	)
{
	m_bRemove.setEnabled  (true) ;
	m_list   .setSelected (index, true) ;
}

/*  TKCListAddRem							*/
/*  clear	: Clear list						*/
/*  (returns)	: void		:					*/

void	TKCListAddRem::clear ()
{
	m_list   .clear      () ;
	m_edit   .clear      () ;
	m_bRemove.setEnabled (false) ;
}

/*  TKCListAddRem							*/
/*  addToList	: Add entry to list					*/
/*  text	: const QString & : Value to add			*/
/*  (returns)	: void		  :					*/

void	TKCListAddRem::addToList
	(	const QString	&text
	)
{
	if (m_sorted)
		for (uint idx = 0 ; idx < m_list.count() ; idx += 1)
			if (m_list.text(idx) > text)
			{	m_list.insertItem (text, idx) ;
				return	;
			}

	m_list.insertItem (text) ;
}
