/***************************************************************************
    file	         : kb_attrframe.cpp
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#include	"kb_attrframe.h"

#if		! __KB_RUNTIME
#include	"kb_attrframedlg.h"

static	IntChoice	choiceShape  [] =
{
	{	0,		"NoFrame"	},
	{	0x0001,		"Box"		},
	{	0x0002,		"Panel"		},
	{	0x0003,		"WinPanel"	},
	{	0x0004,		"HLine"		},
	{	0x0005,		"VLine"		},
	{	0x0006,		"StyledPanel"	},
	{	0x0007,		"PopupPanel"	},
	{	-1,		0		}
}	;

static	IntChoice	choiceShadow [] =
{
	{	0x0010,		"Plain"		},
	{	0x0020,		"Raised"	},
	{	0x0030,		"Sunken"	},
	{	-1,		0		}
}	;


/*  KBAttrFrame								*/
/*  getAttrDlg	: Get dialog component for frame			*/
/*  parent	: QWidget *		: Parent widget			*/
/*  item	: KBAttrItem *		: Associated item		*/
/*  attrDict	: QDict<KBAttrItem> &	: Attribute dictionary		*/
/*  (returns)	: KBAttrDlg *		: Actually KBAttrFrameDlg	*/

KBAttrDlg *KBAttrFrame::getAttrDlg
	(	QWidget			*parent,
		KBAttrItem		*item,
		QDict<KBAttrItem>	&attrDict
	)
{
	return	new KBAttrFrameDlg (parent, this, item, attrDict) ;
}

/*  KBAttrFrame								*/
/*  displayValue: Get display text for value				*/
/*  value	: const QString & : Actual value			*/
/*  (returns)	: QString	  : Display text for value		*/

QString	KBAttrFrame::displayValue
	(	const QString	&value
	)
{
	int	style	= 0 ;
	int	width	= 0 ;
	int	coff	= value.find  (',')	  ;

	if (coff < 0) return "" ;

	style	= value.left(coff    ).toInt() ;
	width	= value.mid (coff + 1).toInt() ;

	QString		display	    ;
	IntChoice	*shadow	= 0 ;
	IntChoice	*shape	= 0 ;

	for (IntChoice *ic1 = &choiceShadow[0] ; ic1->descr != 0 ; ic1 += 1)
		if (ic1->value == (style & QFrame::MShadow))
		{	shadow	= ic1	;
			break	;
		}
	for (IntChoice *ic2 = &choiceShape [0] ; ic2->descr != 0 ; ic2 += 1)
		if (ic2->value == (style & QFrame::MShape))
		{	shape	= ic2	;
			break	;
		}

	if	((shadow != 0) && (shape != 0))
		display	= QString("%1,%2 ").arg(shadow->descr).arg(shape->descr) ;
	else if ((shadow != 0))
		display	= QString("%1 ").arg(shadow->descr) ;
	else if ((shape  != 0))
		display	= QString("%1 ").arg(shape ->descr) ;

	return	display + QString(TR("width %1")).arg(width) ;
}

IntChoice *KBAttrFrame::getChoiceShadow ()
{
	return	choiceShadow ;
}

IntChoice *KBAttrFrame::getChoiceShape  ()
{
	return	choiceShape  ;
}

#endif

int	KBAttrFrame::dummy ()
{
	return	0	;
}
