/***************************************************************************
    file	         : kb_attrmargin.h
    copyright            : (C)	1999,2000,2001,2002,2003,2004,2005
				 by Mike Richardson
			   (C)	2001,2002,2003,2004,2005
				by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/


#ifndef	__KB_ATTRMARGIN_H
#define	__KB_ATTRMARGIN_H

#include	"kb_attr.h"
#include	"kb_object.h"

class	KBAttrItem	;

/*  KBAttrMargin							*/
/*  ------------							*/
/*  Class used for report margin settings, wraps the four values into	*/
/*  one attribute.							*/

class	LIBKBASE_API	KBAttrMargin : public KBAttr
{
public	:

	int		m_lMargin	;
	int		m_rMargin	;
	int		m_tMargin	;
	int		m_bMargin	;

	KBAttrMargin
	(	KBObject		*,
		const QDict<QString>	&,
		uint			= 0
	)	;
	KBAttrMargin
	(	KBObject		*,
		KBObject		*
	)	;

	virtual	QString		getValue	() const	;
	virtual	void		printAttr 	(QString &, QString &, int) ;

#if	! __KB_RUNTIME
	virtual	KBAttrItem	*getAttrItem	() ;
#endif

}	;

#endif	// __KB_ATTRMARGIN_H
