/***************************************************************************
    file	         : kb_attrvpage.cpp
    copyright            : (C)	1999,2000,2001,2002,2003,2004,2005
				 by Mike Richardson
			   (C)	2001,2002,2003,2004,2005
				by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/


#include	"kb_attrvpage.h"
#include	"kb_attrvpagedlg.h"


static	int	getAttrValue
	(	const QDict<QString>	&aDict,
		cchar			*name,
		int			defval
	)
{
	QString	*v = aDict.find (name)  ;
	return	v == 0 ? defval : v->toInt() ;
}



/*  KBAttrVPage								*/
/*  KBAttrVPage	: Constructor for virtual page attribute		*/
/*  owner	: KBObject *		: Owning object			*/
/*  item	: KBAttrItem *		: Associated item		*/
/*  attrDict	: QDict<KBAttrItem> &	: Attribute dictionary		*/
/*  (returns)	: KBAttrVPage		:				*/

KBAttrVPage::KBAttrVPage
	(	KBObject		*owner,
		const QDict<QString>	&aDict,
		uint			flags
	)
	:
	KBAttr	(owner, KBAttr::Base, "_vpage", aDict, flags|KAF_GRPFORMAT)
{
	m_enabled	= getAttrValue	(aDict, "vpenabled", 0) ;
	m_colWidth	= getAttrValue	(aDict, "vpcolw",    0) ;
	m_rowHeight	= getAttrValue	(aDict, "vprowh",    0) ;
	m_colGap	= getAttrValue	(aDict, "vpcolg",    0) ;
	m_rowGap	= getAttrValue	(aDict, "vprowg",    0) ;
	m_borders	= getAttrValue	(aDict, "vpborders", 0) ;
	m_skip		= getAttrValue	(aDict, "vpskip",    0) ;
}

/*  KBAttrVPage								*/
/*  KBAttrVPage	: Constructor for VPage attribute			*/
/*  owner	: KBObject *		: Owning object			*/
/*  extant	: KBObject *		: Extant object			*/
/*  (returns)	: KBAttrVPage		:				*/

KBAttrVPage::KBAttrVPage
	(	KBObject		*owner,
		KBObject		*extant
	)
	:
	KBAttr
	(	owner,
		"_vpage",
		extant,
		extant->getAttr("_vpage")->getFlags()
	)
{
	KBAttrVPage *o = (KBAttrVPage *)extant->getAttr("_vpage") ;

	m_enabled	= o->m_enabled	 ;
	m_colWidth	= o->m_colWidth  ;
	m_rowHeight	= o->m_rowHeight ;
	m_colGap	= o->m_colGap    ;
	m_rowGap	= o->m_rowGap    ;
	m_borders	= o->m_borders	 ;
	m_skip		= o->m_skip	 ;
}

/*  KBAttrVPage								*/
/*  printAttr	: Print attribute					*/
/*  attrText	: QString &	: Result text for attribute output	*/
/*  nodeText	: QString &	: Result text for node output		*/
/*  indent	: int		: Indent depth for node output		*/
/*  (returns)	: void		:					*/

void	KBAttrVPage::printAttr
	(	QString		&attrText,
		QString		&,
		int		
	)
{
	addAttrText (attrText, "vpenabled", QString::number(m_enabled)	) ;
	addAttrText (attrText, "vpcolw",    QString::number(m_colWidth)	) ;
	addAttrText (attrText, "vprowh",    QString::number(m_rowHeight)) ;
	addAttrText (attrText, "vpcolg",    QString::number(m_colGap)	) ;
	addAttrText (attrText, "vprowg",    QString::number(m_rowGap)	) ;
	addAttrText (attrText, "vpborders", QString::number(m_borders)	) ;
	addAttrText (attrText, "vpskip",    QString::number(m_skip)	) ;
}

/*  KBAttrVPage								*/
/*  getValue	: Get value						*/
/*  (returns)	: QString	: Value					*/

QString	KBAttrVPage::getValue () const
{
	/* Should not actually be called, so its really just a bit of a	*/
	/* filler.							*/
	return	QString	("%1: %2,%3,%4,%5")
			.arg(m_enabled ? TR("On") : TR("Off"))
			.arg(m_colWidth )
			.arg(m_rowHeight)
			.arg(m_colGap   )
			.arg(m_rowGap   )
			;
}

#if	! __KB_RUNTIME

/*  KBAttrVPage								*/
/*  getAttrItem	: Get item for property dialogs				*/
/*  (returns)	: KBAttrItem *	:					*/

KBAttrItem
	*KBAttrVPage::getAttrItem ()
{
	return	new KBAttrVPageItem (this) ;
}

#endif
