/***************************************************************************
    file	         : kb_check.cpp
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#include	<stdio.h>
#include	<stdlib.h>
#include	<ctype.h>

#include	<qapplication.h>
#include	<qlist.h>
#include	<qstring.h>
#include	<qcursor.h>

#include	"kb_classes.h"
#include	"kb_type.h"
#include	"kb_value.h"

#include	"kb_sizer.h"
#include	"kb_display.h"
#include	"kb_ctrl.h"
#include	"kb_formblock.h"
#include	"kb_check.h"
#include	"kb_qtcheck.h"
#include	"kb_nodereg.h"
#include	"kb_layout.h"

#if		! __KB_RUNTIME
#include	"kb_propdlg.h"
#endif

/*  KBCheck								*/
/*  KBCheck	: Constructor for simple form field			*/
/*  parent	: KBNode *	: Parent node				*/
/*  aList	: const QDict<QString> &				*/
/*				: List of attributes			*/
/*  ok		: bool *	: Success				*/
/*  (returns)	: KBNode	:					*/

KBCheck::KBCheck
	(	KBNode			*parent,
		const QDict<QString>	&aList,
		bool			*ok
	)
	:
	KBItem	(parent, "KBCheck",	"expr", 	aList),
	fgcolor	(this,   "fgcolor",			aList),
	bgcolor	(this,   "bgcolor",			aList),
	onChange(this,	 "onchange",	"onCheck",	aList)
{
#if	! __KB_RUNTIME
	if (ok != 0)
	{
		KBPropDlg cDlg (this, "Field", attribs, 0) ;
		if (!cDlg.exec ())
		{	delete	this	;
			*ok	= false	;
			return	;
		}

		*ok	= true     ;
	}
#endif
}

/*  KBCheck								*/
/*  KBCheck	: Constructor for simple form field			*/
/*  _parent	: KBNode *	: Parent node				*/
/*  _check	: KBCheck *	: Extant check				*/
/*  (returns)	: KBNode	:					*/

KBCheck::KBCheck
	(	KBNode		*_parent,
		KBCheck		*_check
	)
	:
	KBItem	(_parent, "expr", 			_check),
	fgcolor	(this,    "fgcolor",			_check),
	bgcolor	(this,    "bgcolor",			_check),
	onChange(this,	 "onchange",	"onCheck",	_check)
{
}

/*  KBCheck								*/
/*  ~KBCheck	: Destructor for simple form field			*/
/*  (returns)	:		:					*/

KBCheck::~KBCheck ()
{
//	fprintf	(stderr, "Delete check: %s\n", (cchar *)expr.getValue()) ;
}

/*  KBCheck								*/
/*  makeCtrl	: Make a check control					*/
/*  drow	: uint		: Display row number			*/
/*  (returns)	: KBControl *	: Associated control			*/

KBControl *KBCheck::makeCtrl
	 (	uint	drow
	 )
{
	return	new KBCtrlCheck (getDisplay(), this, drow) ;
}

/*  KBCheck								*/
/*  userChange	: Checkbox changed notification				*/
/*  qrow	: uint		: Query row number			*/
/*  set		: bool		: Set/unset state			*/
/*  (returns)	: void		:					*/

void	KBCheck::userChange
	(	uint	qrow,
		bool	set
	)
{
	KBValue	args[2]	;
	bool	evRc	;

	args[0] = (int)qrow ;
	args[1] = (int)set  ;

	eventHook (onChange, 2, args, evRc) ;

	KBItem::userChange (qrow) ;
}

/*  KBCheck								*/
/*  replicate	: Replicate this check					*/
/*  _parent	: KBNode *	: Parent of replicant			*/
/*  (returns)	: KBNode *	: New check node			*/

KBNode	*KBCheck::replicate
	(	KBNode	*_parent
	)
{
	return	new KBCheck (_parent, this) ;
}



#if	! __KB_RUNTIME
/*  KBCheck								*/
/*  propertyDlg	: Show property dialog					*/
/*  (returns)	: bool		: Success				*/

bool	KBCheck::propertyDlg ()
{
	KBPropDlg fDlg (this, "CheckBox", attribs, 0) ;

	if (!fDlg.exec ()) return false ;

	updateProps () ;
	return	true   ;
}
#endif

NEWNODE(Check, __TR("New Chec&k"), KF_FORM|KF_BLOCK|KF_DATA)
