/***************************************************************************
    file	         : kb_choicedlg.cpp
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#include	<stdio.h>

#include	<qframe.h>
#include	<qmessagebox.h>

#include	"kb_classes.h"
#include	"kb_type.h"
#include	"kb_value.h"

#include	"kb_attr.h"
#include	"kb_dbinfo.h"
#include	"kb_qrybase.h"
#include	"kb_block.h"
#include	"kb_choice.h"

#ifndef 	_WIN32
#include	"kb_choicedlg.moc"
#else
#include	"kb_choicedlg.h"
#endif


/*  KBChoicePropDlg							*/
/*  KBChoicePropDlg: Constructor for block properties dialog		*/
/*  choice	  : KBChoice *	  : Parent choice			*/
/*  caption	  : const char *  : Dialog box caption			*/
/*  attribs	  : QList<KBAttr>&: List of attributes			*/
/*  iniAttr	  : cchar *	  : Initial attribute			*/
/*  (returns)	  : KBChoicePropDlg:					*/

KBChoicePropDlg::KBChoicePropDlg
	(	KBChoice	*choice,
		cchar		*caption,
		QList<KBAttr>	&attribs,
		cchar		*iniAttr
	)
	:
	KBItemPropDlg	(choice, caption, attribs, iniAttr),
	choice		(choice)
{
}

/*  KBChoicePropDlg							*/
/*  ~KBChoicePropDlg: Destructor for choice properties dialog		*/
/*  (returns)	    : void	:					*/

KBChoicePropDlg::~KBChoicePropDlg ()
{
}


/*  KBChoicePropDlg							*/
/*  showProperty: Show property						*/
/*  item	: KBAttrItem *	: Associated item			*/
/*  (returns)	: bool		: Property on show			*/

bool	KBChoicePropDlg::showProperty
	(	KBAttrItem	*item
	)
{
	return	KBItemPropDlg::showProperty (item) ;
}

/*  KBChoicePropDlg							*/
/*  saveProperty: Check and save attribute				*/
/*  item	: KBAttrItem *	: Associated item			*/
/*  (returns)	: bool		: Attribute OK				*/

bool	KBChoicePropDlg::saveProperty
	(	KBAttrItem	*item
	)
{
	return	KBItemPropDlg::saveProperty (item) ;
}

/*  ChoicePropDlg  : Run the choice properties dialog			*/
/*  choice	  : KBChoice *	  : Parent choice			*/
/*  caption	  : const char *  : Dialog box caption			*/
/*  attribs	  : QList<KBAttr>&: List of attributes			*/
/*  iniAttr	  : cchar *	  : Initial attribute			*/
/*  (returns)	  : bool	  : Success				*/

bool LIBKBASE_API choicePropDlg
	(	KBChoice	*choice,
		cchar		*caption,
		QList<KBAttr>	&attribs,
		cchar		*iniAttr
	)
{
	KBChoicePropDlg fDlg (choice, caption, attribs, iniAttr) ;
	return	fDlg.exec () ;
}
