/***************************************************************************
    file	         : kb_copyfile.h
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#ifndef	__KB_COPYFILE_H
#define	__KB_COPYFILE_H

#include 	"libkbase_exports.h"

#include	<qfile.h>
#include	<qtextstream.h>
#include	<qstringlist.h>
#include	<qarray.h>

#include	"kb_location.h"
#include	"kb_dom.h"

class 	LIBKBASE_API	KBCopyFile : public KBCopyBase
{
	enum
	{	UseDelimited	= 0,
		UseFixed	= 1
	}	;
	enum
	{	ErrPad		= 0,
		ErrSkip		= 1,
		ErrAbort	= 2
	}	;

	bool		m_srce	   ;
	KBLocation	m_location ;

	uint		m_which	   ;	/* Delimited, fixed, ...	*/
	uint		m_erropt   ;	/* Line error option		*/
	QString		m_file	   ;	/* File name			*/
	QString		m_useFile  ;	/* Paramater substituted	*/
	bool		m_header   ;	/* File has header line		*/
	uint		m_skip	   ;	/* Header skip count		*/

					/* FIXED			*/
	QStringList	m_names	   ;	/* Nominal field name		*/
	QValueList<uint>m_offsets  ;	/* Set of field offsets		*/
	QValueList<uint>m_widths   ;	/* Set of field widths		*/
	QValueList<bool>m_strip	   ;	/* Strip white space		*/

					/* DELIMITED			*/
	QChar		m_delim	   ;	/* Delimiter character		*/
	QChar		m_qualif   ;	/* Qualifier character		*/
	QString		m_copyList ;	/* Source columns to copy	*/
	QValueList<uint>m_copyMap  ;

	QStringList	m_columns  ;	/* Names from header line	*/
	KBValue		*m_local   ;

	QFile		m_io	   ;
	uint		m_maxlen   ;
	uint		m_nRows	   ;
	QTextStream	m_stream   ;
	QString		m_buffer   ;

	QString			nextQualified	(uint &)	  ;
	int			fixedScan	(KBValue *, uint) ;
	int			qualifScan	(KBValue *, uint) ;
	int			delimScan	(KBValue *, uint) ;

public	:

	KBCopyFile		(bool, KBLocation &)	;
	virtual	~KBCopyFile	()		;

	virtual	cchar		*tag		() ;

	virtual	bool		valid		(KBError     &) ;
	virtual	bool		set		(QDomElement &, KBError &) ;
	virtual	void		def		(QDomElement &) ;
	
	virtual	void		getColumnNames	(QStringList &) ;
	virtual	bool		prepare		(const QDict<QString>   &, KBCopyBase *) ;
	virtual	int		getNumCols	() ;
	virtual	int		getRow		(KBValue *, uint, bool  &) ;
	virtual	bool		putRow		(KBValue *, uint  ) ;
	virtual	bool		finish		(QString &) ;

	void			setWhich	(uint) ;
	void			setErrOpt	(uint) ;
	void			setFile		(const QString &) ;
	void			setDelim	(const QString &) ;
	void			setQualif	(const QString &) ;
	void			setCopyList	(const QString &) ;
	void			setHeader	(bool, uint) ;
	void			addField	(const QString &, uint, uint, bool) ;

	inline	uint		&getWhich	() { return m_which	; }
	inline	uint		&getErrOpt	() { return m_erropt	; }
	inline	const QString	&getFile	() { return m_file	; }
	inline	const QString	getDelim	() { return m_delim	; }
	inline	const QString	getQualif	() { return m_qualif	; }
	inline	const QString	getCopyList	() { return m_copyList	; }

	inline	bool		getHeader
				(	uint	&skip
				)
	{
		skip	= m_skip	;
		return	m_header	;
	}

	bool			getField	(uint, QString &, uint &, uint &, bool &) ;

	void			reset		() ;

}	;

#endif	// __KB_COPYFILE_H
