/***************************************************************************
    file	         : kb_copyquery.h
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#ifndef	__KB_COPYQUERY_H
#define	__KB_COPYQUERY_H

#include 	"libkbase_exports.h"

#include	<qstringlist.h>

#include	"kb_dom.h"
#include	"kb_location.h"
#include	"kb_dblink.h"
#include	"kb_database.h"


class 	LIBKBASE_API	KBCopyQuery : public KBCopyBase
{
	bool		m_srce	   ;
	KBLocation	m_location ;

	QString		m_server   ;
	QString		m_query	   ;
	QStringList	m_fields   ;

	KBDBLink	m_dbLink   ;	/* Link to database server	*/

	bool		m_qExec	   ;	/* Query executed flag		*/
	KBSQLSelect	*m_select  ;

	uint		m_sRow	   ;	/* Select row count		*/

public	:

	KBCopyQuery		(bool, KBLocation &)	;
	virtual	~KBCopyQuery	()		;

	virtual	cchar		*tag		() ;

	virtual	bool		valid		(KBError     &) ;
	virtual	bool		set		(QDomElement &, KBError &) ;
	virtual	void		def		(QDomElement &) ;
	
	virtual	void		getColumnNames	(QStringList &) ;
	virtual	bool		prepare		(const QDict<QString>   &, KBCopyBase *) ;
	virtual	int		getNumCols	() ;
	virtual	int		getRow		(KBValue *, uint, bool  &) ;
	virtual	bool		putRow		(KBValue *, uint  ) ;
	virtual	bool		finish		(QString &) ;

	void			reset		() ;
	void			setServer	(const QString &) ;
	void			setQuery	(const QString &) ;
	void			addField	(const QString &) ;

	inline const QString	&getServer	() { return m_server   ; }
	inline const QString	&getQuery	() { return m_query    ; }
	inline QStringList	&getFields	() { return m_fields   ; }
}	;

#endif	// __KB_COPYTABLE_H
