/***************************************************************************
    file	         : kb_dictionary.h
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#ifndef	__KB_DICTIONARY_H
#define	__KB_DICTIONARY_H

#include "libkbase_exports.h"

#include	<qlist.h>
#include	<qdict.h>


/*  KBDictEntry								*/
/*  -----------								*/
/*  Structure used to handle dictionary entries. Only a class so that	*/
/*  we can initialise the m_extra pointer.				*/

class	LIBKBASE_API	KBDictEntry
{
public	:

	QString		m_legend	;	/* PE legend		*/
	QString		m_descrip	;	/* PE descriptive text	*/
	QString		m_nullchk	;	/* PE null check error	*/
	QDict<QString>	*m_extra	;	/* Additional values	*/

	inline	KBDictEntry ()
	{
		m_extra	= 0	;
	}

}	;

/*  KBDictionary							*/
/*  ------------							*/
/*  Rekall uses a dictionary to hold information, mainly for use in	*/
/*  the property editor, but also for some other places. This is loaded	*/
/*  from dictionary files. It is done this way since it separates out	*/
/*  the (large volume) of text from the source code.			*/

class	LIBKBASE_API	KBDictionary
{
	QDict<KBDictEntry>	m_dict	;

	void		loadFile	(const QString &) ;
	KBDictEntry	*lookup		(const QString &, const QString &) ;

public	:

	KBDictionary	(QString)	;

	QString			getAttrLegend	   (const QString &, const QString &) ;
	QString			getAttrDescription (const QString &, const QString &) ;
	QString			getAttrNullcheck   (const QString &, const QString &) ;
	QString			getAttrExtra	   (const QString &, const QString &, const QString &) ;

	QList<KBDictEntry>	getMatching 	   (const QString &, const QString &) ;
}	;

#endif	// __KB_DICTIONARY_H
