/***************************************************************************
    file	         : kb_draglist.cpp
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#ifndef 	_WIN32
#include	"kb_draglist.moc"
#else
#include	"kb_draglist.h"
#endif

/*  KBDragBox								*/
/*  KBDragBox	: Constructor for dragable list box			*/
/*  parent	: QWidget *	: Parent widget				*/
/*  bUp		: QPushButton *	: Move up button			*/
/*  bDown	: QPushButton *	: Move down button			*/
/*  (returns)	: KBDragBox	:					*/

KBDragBox::KBDragBox
	(	QWidget		*parent,
		QPushButton	*bUp,
		QPushButton	*bDown
	)
	:
	QListBox (parent)
{
	mouseDownAt = -1 ;
	mouseUpAt   = -1 ;

	if (bUp   != 0)
		connect (bUp,   SIGNAL(clicked()), SLOT(clickMoveUp  ())) ;
	if (bDown != 0)
		connect (bDown, SIGNAL(clicked()), SLOT(clickMoveDown())) ;
}

/*  KBDragBox								*/
/*  mousePressEvent : Handle mouse press				*/
/*  e		    : QMouseEvent *	: Mouse event			*/
/*  (returns)	    : void		:				*/

void	KBDragBox::mousePressEvent
	(	QMouseEvent *e
	)
{
	/* Simply note the mouse position in terms of the offest into	*/
	/* the displayed list, then do the default processing.		*/
	mouseDownAt = findItem (e->y()) ;
	QListBox::mousePressEvent (e)   ;
}

/*  KBDragBox								*/
/*  mouseReleaseEvent: Handle mouse release				*/
/*  e		     : QMouseEvent *	: Mouse event			*/
/*  (returns)	     : void		:				*/

void	KBDragBox::mouseReleaseEvent
	(	QMouseEvent *e
	)
{
	/* First, note the mouse position in terms of the offest into	*/
	/* the displayed list, then do the default processing.		*/
	mouseUpAt   = findItem (e->y()) ;
	QListBox::mousePressEvent (e)   ;

	/* If we now have mouse down and up positions, and they are	*/
	/* different, then move the entry at the down position to the	*/
	/* up position, and emit a signal to the outside world.		*/
	if ( (mouseUpAt   >= 0) &&
	     (mouseDownAt >= 0) && (mouseUpAt != mouseDownAt) )
	{
		QListBoxItem *move = item(mouseDownAt) ;

		takeItem (move) ;

		if (mouseUpAt < mouseDownAt)
			insertItem (move, mouseUpAt    ) ;
		else	insertItem (move, mouseUpAt - 1) ;

		emit moved (mouseDownAt, mouseUpAt) ;
	}

	/* All down for now so clear the positions for the next time	*/
	/* round.							*/
	mouseDownAt = -1 ;
	mouseUpAt   = -1 ;
}

/*  KBDragBox							*/
/*  clickMoveUp	 : Handle click of the move-up button			*/
/*  (returns)	 : void		:					*/

void	KBDragBox::clickMoveUp ()
{
	int		idx	;
	QListBoxItem	*cur	;

	if ((idx = currentItem()) <= 0) return ;
	if ((cur = item    (idx)) == 0) return ;

	takeItem       (cur) ;
	insertItem     (cur, idx - 1) ;
	setCurrentItem (cur) ;
}

/*  KBDragBox							*/
/*  clickMoveDown: Handle click of the move-down button			*/
/*  (returns)	 : void		:					*/

void	KBDragBox::clickMoveDown ()
{
	int		idx	;
	QListBoxItem	*cur	;

	if ((idx = currentItem())  < 0) return ;
	if ((cur = item    (idx)) == 0) return ;
	if (idx >= (int)  count()  - 1) return ;

	takeItem       (cur) ;
	insertItem     (cur, idx + 1) ;
	setCurrentItem (cur) ;
}
