/***************************************************************************
    file	         : kb_finddlg.cpp
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#ifndef		_WIN32
#include	"kb_finddlg.moc"
#else
#include	"kb_finddlg.h"
#endif


#include	"kb_classes.h"
#include	"kb_formblock.h"


static	bool	use_regexp	;
static	bool	use_sensitive	;
static	bool	use_backwards	;
static	bool	use_wholeText	;
static	QString	use_text	;
static	uint	use_choice	;

/*  KBFindDlg								*/
/*  KBFindDlg	: Constructor for record find dialog			*/
/*  block	: KBFormBlock *	: Invoking block			*/
/*  item	: KBItem *	: Invoking item				*/
/*  options	: uint		: Options flags				*/
/*  (returns)	: KBFindDlg	:					*/

KBFindDlg::KBFindDlg
	(	KBFormBlock	*block,
		KBItem		*item,
		uint		options
	)
	:
	_KBDialog	(TR("Search for"), true),
	m_findBox	(1, Qt::Horizontal, TR("Find"   ), this),
	m_optionsBox	(1, Qt::Horizontal, TR("Options"), this),
	m_statusBox	(1, Qt::Horizontal, TR("Status" ), this),
	m_finder	(&m_findBox),
	m_regexp	(&m_findBox),
	m_sensitive	(&m_optionsBox),
	m_backwards	(&m_optionsBox),
	m_wholeText	(&m_optionsBox),
	m_status	(&m_statusBox),
	m_bFind		(this),
	m_bCancel	(this),
	m_block		(block),
	m_item		(item),
	m_options	(options)
{
	QVBoxLayout	*layMain = new QVBoxLayout (this) ;
	layMain->addWidget (&m_findBox   ) ;
	layMain->addWidget (&m_optionsBox) ;
	layMain->addWidget (&m_statusBox ) ;

	QHBoxLayout	*layButt = new QHBoxLayout (layMain) ;
	layButt->addStretch() ;
	layButt->addWidget (&m_bFind	 ) ;
	layButt->addWidget (&m_bCancel	 ) ;


	m_regexp	.setText (TR("Regular expression")) ;
	m_sensitive	.setText (TR("Case sensitive"	 )) ;
	m_backwards	.setText (TR("Backwards"	 )) ;
	m_wholeText	.setText (TR("Whole text"	 )) ;

	m_bFind		.setText (TR("Find"		 )) ;
	m_bCancel	.setText (TR("Cancel"		 )) ;


	m_bFind		.setDefault (true) ;

	m_regexp	.setChecked (use_regexp		 )  ;
	m_sensitive	.setChecked (use_sensitive	 )  ;
	m_backwards	.setChecked (use_backwards	 )  ;
	m_wholeText	.setChecked (use_wholeText	 )  ;

	m_regexp	.setEnabled ((m_options & ShowRegexp   ) != 0) ;
	m_sensitive	.setEnabled ((m_options & ShowSensitive) != 0) ;
	m_wholeText	.setEnabled ((m_options & ShowWholeText) != 0) ;

	connect	(&m_bFind,   SIGNAL(clicked()), SLOT(slotClickFind  ())) ;
	connect	(&m_bCancel, SIGNAL(clicked()), SLOT(slotClickCancel())) ;

	m_status.setText
	(	QString	(TR("At record %1 of %2"))
			.arg(m_block->getCurQRow())
			.arg(m_block->getNumRows())
	)	;
}

/*  KBFindDlg								*/
/*  slotClickFind: User clicks the find button				*/
/*  (returns	 : void		:					*/

void	KBFindDlg::slotClickFind ()
{
	uint	curQRow	= m_block->getCurQRow   () ;
	uint	gotoRow	= 0x7fffffff	;

	use_regexp	= m_regexp   .isChecked () ;
	use_sensitive	= m_sensitive.isChecked () ;
	use_backwards	= m_backwards.isChecked () ;
	use_wholeText	= m_wholeText.isChecked () ;

	if (!prepare ()) return ;

	if (use_backwards)
	{
		for (uint row = 1 ; row <= curQRow ; row += 1)
			if (matched (curQRow - row))
			{	gotoRow	= curQRow - row ;
				break	;
			}
	}
	else
	{
		for (uint row = curQRow + 1 ; row < m_block->getNumRows () ; row += 1)
			if (matched (row))
			{	gotoRow	= row ;
				break	;
			}
	}

	if (gotoRow == 0x7fffffff)
	{
		m_status.setText (TR("No match found")) ;
		return	;
	}

	m_block->doOperation (KB::GotoQRow, gotoRow, 0) ;

	m_status.setText
	(	QString	(TR("At record %1 of %2"))
			.arg(m_block->getCurQRow() + 1)
			.arg(m_block->getNumRows())
	)	;
}

/*  KBFindDlg								*/
/*  slotClickCancel							*/
/*		: User clicks the cancel button				*/
/*  (returns	: void		:					*/

void	KBFindDlg::slotClickCancel ()
{
	done	(0)	;
}


/*  ------------------------------------------------------------------  */

/*  KBFindTextDlg							*/
/*  KBFindTextDlg							*/
/*		: Constructor for record find text dialog		*/
/*  block	: KBFormBlock *	: Invoking block			*/
/*  item	: KBItem *	: Invoking item				*/
/*  (returns)	: KBFindDlg	:					*/

KBFindTextDlg::KBFindTextDlg
	(	KBFormBlock	*block,
		KBItem		*item
	)
	:
	KBFindDlg
	(	block,
		item,
		KBFindDlg::ShowRegexp|KBFindDlg::ShowSensitive|KBFindDlg::ShowWholeText
	),
	m_findText	(&m_finder)
{
	m_findText.setText (use_text) ;

	if (m_regexp.isChecked())
		m_bFind.setEnabled (QRegExp(use_text).isValid()) ;
	else	m_bFind.setEnabled (!use_text.isEmpty()) ;

	m_finder.setFixedHeight  (m_findText.sizeHint().height()) ;

	connect
	(	&m_findText,
		SIGNAL(    textChanged(const QString &)),
		SLOT  (slotTextChanged(const QString &))
	)	;
	connect
	(	&m_regexp,
		SIGNAL(    	 toggled(bool)),
		SLOT  (slotRegexpToggled(bool))
	)	;

	m_findText.setFocus () ;
}

/*  KBFindTextDlg							*/
/*  slotTextChanged							*/
/*		: User changes text					*/
/*  text	: const QString & : New text				*/
/*  (returns)	: void		  :					*/

void	KBFindTextDlg::slotTextChanged
	(	const QString	&text
	)
{
	if (m_regexp.isChecked())
		m_bFind.setEnabled (QRegExp(text).isValid()) ;
	else	m_bFind.setEnabled (!text.isEmpty()) ;
}


/*  KBFindTextDlg							*/
/*  slotRegexpToggled							*/
/*		: User changes regexp selection				*/
/*  on		: bool		: Use regexp				*/
/*  (returns)	: void		:					*/

void	KBFindTextDlg::slotRegexpToggled
	(	bool		on
	)
{
	if (on)
		m_bFind.setEnabled (QRegExp(m_findText.text()).isValid()) ;
	else	m_bFind.setEnabled (!m_findText.text().isEmpty()) ;
}


/*  KBFindTextDlg							*/
/*  prepare	: Prepare search					*/
/*  (returns)	: bool		: Success				*/

bool	KBFindTextDlg::prepare ()
{
	use_text = m_findText.text  () ;
	if (use_text.isEmpty())
		return	false ;

	if (!use_sensitive)
		use_text = use_text.lower () ;

	if ( use_regexp)
		if (((m_options & ShowWholeText) != 0) && use_wholeText)
			m_srchRegexp = QRegExp ("^" + use_text + "$") ;
		else	m_srchRegexp = QRegExp (use_text) ;

	return	true	;
}

/*  KBFindTextDlg							*/
/*  matched	: See if row is matched					*/
/*  qrow	: uint		  : Row to check			*/
/*  (returns	: bool		  : Matched				*/

bool	KBFindTextDlg::matched
	(	uint		qrow
	)
{
	QString	qrowText = m_item->getSearchText (qrow) ;

	if (!use_sensitive)
		qrowText = qrowText.lower() ;

//	fprintf
//	(	stderr,
//		"KBFindTextDlg::matched: [%s]==[%s]\n",
//		(cchar *)qrowText,
//		(cchar *)use_text
//	)	;

	if (use_regexp)
		return	qrowText.find (m_srchRegexp) >= 0 ;

	if (use_wholeText)
		return	qrowText == use_text ;

	return	qrowText.find (use_text) >= 0 ;
}

/*  ------------------------------------------------------------------  */

/*  KBFindChoiceDlg							*/
/*  KBFindChoiceDlg							*/
/*		: Constructor for record find choice dialog		*/
/*  block	: KBFormBlock *	: Invoking block			*/
/*  item	: KBItem *	: Invoking item				*/
/*  choices	: QStringList &	: List of choices			*/
/*  values	: QStringList &	: List of values			*/
/*  (returns)	: KBFindDlg	:					*/

KBFindChoiceDlg::KBFindChoiceDlg
	(	KBFormBlock		*block,
		KBItem			*item,
		const QStringList	&choices,
		const QStringList	&values
	)
	:
	KBFindDlg
	(	block,
		item,
		0
	),
	m_findChoice	(&m_finder),
	m_choices	(choices),
	m_values	(values)
{
	m_findChoice.insertStringList (m_choices) ;
	m_finder    .setFixedHeight   (m_findChoice.sizeHint().height()) ;
	m_findChoice.setFocus	      () ;

	m_findChoice.setCurrentItem   (use_choice) ;
}


/*  KBFindChoiceDlg							*/
/*  prepare	: Prepare search					*/
/*  (returns)	: bool		: Success				*/

bool	KBFindChoiceDlg::prepare ()
{
	use_choice   = m_findChoice.currentItem () ;
	m_choiceText = m_values[use_choice] ;
	return	true	;
}

/*  KBFindChoiceDlg							*/
/*  matched	: See if row is matched					*/
/*  qrow	: uint		  : Row to check			*/
/*  (returns	: bool		  : Matched				*/

bool	KBFindChoiceDlg::matched
	(	uint		qrow
	)
{
	QString	qrowText = m_item->getSearchText (qrow) ;

//	fprintf
//	(	stderr,
//		"KBFindChoiceDlg::matched: [%s]==[%s]\n",
//		(cchar *)qrowText,
//		(cchar *)m_choiceText
//	)	;

	return	qrowText == m_choiceText ;
}

