/***************************************************************************
    file	         : kb_graphic.cpp
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#include	<qpixmap.h>

#include	"kb_location.h"
#include	"kb_nodereg.h"
#include	"kb_docroot.h"
#include	"kb_ascii.h"

#ifndef		_WIN32
#include	"kb_graphic.moc"
#else
#include	"kb_graphic.h"
#endif

/*  KBGraphic								*/
/*  KBGraphic	: Consructor for embedded graphic node			*/
/*  parent	: KBNode *	: Parent node				*/
/*  aList	: const QDict<QString> &				*/
/*				: List of attributes			*/
/*  ok		: bool *	: Success				*/
/*  (returns)	: KBGraphic	:					*/

KBGraphic::KBGraphic
	(	KBNode			*parent,
		const QDict<QString>	&aList,
		bool			*ok
	)
	:
	KBObject	(parent, "KBGraphic", 	aList),
	m_image		(this,	 "image",	aList),
	m_autosize	(this,	 "autosize",	aList)
{
	m_graphic = 0 ;
	m_report  = 0 ;

#if	! __KB_RUNTIME
	if (ok != 0)
	{
		if (!::graphicPropDlg (this, "Graphic", attribs))
		{	delete this	;
			*ok	= false ;
			return	    ;
		}

		*ok	= true	;
	}
#endif
	if (getParent() != 0) m_report = getParent()->getReport () ;
}

/*  KBGraphic								*/
/*  KBGraphic	: Consructor for embedded graphic			*/
/*  _parent	: KBNode *	: Parent node				*/
/*  _label	: KBGraphic *	: Extant graphic			*/
/*  (returns)	: KBGraphic	:					*/

KBGraphic::KBGraphic
	(	KBNode		*parent,
		KBGraphic	*graphic
	)
	:
	KBObject	(parent,		graphic),
	m_image		(this,	 "image",	graphic),
	m_autosize	(this,	 "autosize",	graphic)
{
	m_graphic = 0 ;
	m_report  = 0 ;

	if (getParent() != 0) m_report = getParent()->getReport () ;
}

/*  KBGraphic								*/
/*  ~KBGraphic	: Desructor for graphic node				*/
/*  (returns)	:		:					*/

KBGraphic::~KBGraphic ()
{
}

/*  KBGraphic								*/
/*  buildCtrls	: Build controls for this node				*/
/*  numrows	: uint		: Number of rows to be displayed	*/
/*  dx		: int		: X offset between rows			*/
/*  dy		: int		: Y offset between rows			*/
/*  (returns)	: void		:					*/

void	KBGraphic::buildCtrls
	(	uint		numrows,
		int		dx,
		int		dy
	)
{
	KBObject::buildCtrls (numrows, dx, dy) ;

	if (m_graphic == 0)
	{
		m_graphic = new KBCtrlGraphic (getDisplay(), this) ;
		setControl (m_graphic)  ;
	}

	m_graphic->KBControl::setGeometry (geometry ()) ;
	m_graphic->KBControl::setVisible  (true) ;
}

/*  KBGraphic								*/
/*  loadImage	: Load image into control				*/
/*  (returns)	: bool		: Success				*/

bool	KBGraphic::loadImage ()
{
	/* If the image value is empty then we will (silently) show a	*/
	/* null image. Otherwise, locate and load the specified one.	*/
	if (!m_image.getValue().isEmpty())
	{
		QStringList	iparts	= QStringList::split ('.', m_image.getValue()) ;

		KBLocation location
		(	getDocRoot()->getDBInfo(),
			"graphic",
			getDocRoot()->getLocation().docLocn,
			iparts[0],
			iparts[1]
		)	;

		KBError	   error	;
		QByteArray image	;

		if (!location.contents (image, error))
		{
			setError (error);
			return	 false	;
		}

		m_graphic->setValue (KBValue(image)) ;
		return	true	;
	}

	return	true	;
}

/*  KBGraphic								*/
/*  showAs	: Set or clear design mode				*/
/*  mode	: KB::ShowAs	: Design mode				*/
/*  (returns)	: void		:					*/

void	KBGraphic::showAs
	(	KB::ShowAs	mode
	)
{
	KBObject::showAs (mode) ;

	if (!loadImage ()) lastError().DISPLAY() ;
}


/*  KBGraphic								*/
/*  replicate	: Replicate this label					*/
/*  _parent	: KBNode *	: Parent of replicant			*/
/*  (returns)	: KBNode *	: New label node			*/

KBNode	*KBGraphic::replicate
	(	KBNode	*_parent
	)
{
	return	new KBGraphic (_parent, this) ;
}


#if	! __KB_RUNTIME

/*  KBGraphic								*/
/*  propertyDlg	: Show property dialog					*/
/*  (returns)	: bool		: Success				*/

bool	KBGraphic::propertyDlg ()
{
	if (!::graphicPropDlg (this, "Graphic", attribs)) return false ;

	updateProps () ;
	if (!loadImage ()) lastError().DISPLAY() ;

	return	true   ;
}
#endif

NEWNODE(Graphic, __TR("New &Graphic"), KF_FORM|KF_REPORT|KF_BLOCK|KF_STATIC)
