/***************************************************************************
    file	         : kb_itemdlg.h
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#ifndef	_KB_ITEMDLG_H
#define	_KB_ITEMDLG_H

#if	! __KB_RUNTIME

#include	"libkbase_exports.h"

#include	"kb_classes.h"
#include	"kb_database.h"
#include	"kb_item.h"

#include	"kb_propdlg.h"


/*  KBItemPropDlg							*/
/*  --------------							*/
/*  Wrapper class for properties dialog for items which display		*/
/*  data values and may have a related control name.			*/

class	LIBKBASE_API	KBItemPropDlg : public KBPropDlg
{
	Q_OBJECT

	KBItem			*m_item		;
	QList<KBFieldSpec>	m_fldList 	;

	bool		loadFieldList	(KBQryBase *, uint, QComboBox *, const QString &, bool) ;

protected :

	KBQryBase	*getBlockQuery	(uint &) ;
	bool		showQueryField	(KBQryBase *, uint, const QString &) ;
	bool		pickQueryField	(KBQryBase *, uint, const QString &, bool = false, QComboBox * = 0) ;

	virtual KBAttrItem
			*getAttrItem	(KBAttr *) ;

	virtual	bool	showProperty	(KBAttrItem *) ;
	virtual	bool	saveProperty	(KBAttrItem *) ;

public	:

	KBItemPropDlg (KBItem *, cchar *, QList<KBAttr> &, cchar * = 0) ;
       ~KBItemPropDlg () ;
}	;

#endif
#endif	// _KB_ITEMDLG_H
