/***************************************************************************
    file	         : kb_loader.h
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#ifndef	__KB_LOADER_H
#define	__KB_LOADER_H


#include	<qstring.h>
#include	<qlabel.h>
#include	<qcheckbox.h>
#include	<qlistview.h>
#include	<qpushbutton.h>

#include	"kb_dbinfo.h"
#include	"kb_dblink.h"
#include	"kb_dialog.h"



class	KBLoaderItem : public QCheckListItem
{
	QString		m_name		;
	uint		m_flags		;
	bool		m_exists	;

public	:

	KBLoaderItem	(QListView *, const QString &, uint, bool) ;

	inline	const QString	&name  ()
	{
		return	m_name	;
	}
	inline	uint		flags  ()
	{
		return	m_flags	;
	}
	inline	uint		exists ()
	{
		return	m_exists;
	}
}	;


/*  KBLoader								*/
/*  --------								*/
/*  Database loader class, used when bulk loading table definitions	*/
/*  and data.								*/

class	LIBKBASE_API	KBLoader : public _KBDialog
{
	Q_OBJECT

	QCheckBox		m_loadAll	;
	QCheckBox		m_loadDefn	;
	QCheckBox		m_loadData	;
	QCheckBox		m_dropObjects	;
	QListView		m_tableList	;

	QLabel			m_loading	;
	QLabel			m_record	;
	QLabel			m_of		;
	QPushButton		m_bOK		;
	QPushButton		m_bCancel	;

	KBDBInfo		*m_dbInfo	;
	QString			m_server	;
	QString			m_dir		;

	bool			m_cancelled	;
	bool			m_finished	;

	KBDBLink		m_dbLink	;
	KBLoaderItem		*m_currItem	;
	uint			m_index		;

	bool			loadXMLSpec
				(	const QString	&,
					cchar		*,
					QDomDocument	&,
					KBError		&
				)	;

	bool			loadTableDef	(const QString &, bool, KBError &) ;
	bool			loadTableData	(const QString &, bool, KBError &) ;
	bool			loadViewDef	(const QString &, bool, KBError &) ;
	bool			loadSequenceDef	(const QString &, bool, KBError &) ;

	bool			loadDetails	(KBLoaderItem  *) ;

protected slots :

	void		slotTimer	()	;
	void		accept 		()	;
	void		reject		()	;

public	:

	KBLoader (KBDBInfo *, const QString &, const QString &) ;

	int		exec		()	;
	bool		showProgress	(int)	;
}	;

#define	FL_TABLEDEF	0x01
#define	FL_VIEWDEF	0x02
#define	FL_SEQDEF	0x04
#define	FL_ANYDEF	0x0f
#define	FL_TABLEDATA	0x10
#define	FL_ANYDATA	0xf0

#endif	// __KB_LOADER_H
