/***************************************************************************
    file	         : kb_memodlg.cpp
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#ifndef 	_WIN32
#include	"kb_memodlg.moc"
#else
#include 	"kb_memodlg.h"
#endif

#include	"kb_block.h"

/*  KBMemoPropDlg							*/
/*  KBMemoPropDlg: Constructor for memo properties dialog		*/
/*  memo	 : KBMemo *	 : Parent memo				*/
/*  caption	 : const char *  : Dialog box caption			*/
/*  attribs	 : QList<KBAttr>&: List of attributes			*/
/*  apply	 : bool	  	 : Show apply button			*/
/*  iniAttr	 : cchar *	 : Initial attribute			*/
/*  (returns)	 : KBMemoPropDlg :					*/

KBMemoPropDlg::KBMemoPropDlg
	(	KBMemo		*memo,
		cchar		*caption,
		QList<KBAttr>	&attribs,
		cchar		*iniAttr
	)
	:
	KBItemPropDlg	(memo, caption, attribs, iniAttr),
	memo		(memo)
{
}

/*  KBMemoPropDlg							*/
/*  ~KBMemoPropDlg: Destructor for memo properties dialog		*/
/*  (returns)	  : void	:					*/

KBMemoPropDlg::~KBMemoPropDlg ()
{
}

/*  KBMemoPropDlg							*/
/*  showProperty: Show property						*/
/*  item	: KBAttrItem *	: Associated item			*/
/*  (returns)	: bool		: Property on show			*/

bool	KBMemoPropDlg::showProperty
	(	KBAttrItem	*item
	)
{
	const QString	&aName	= item->attr()->getName () ;

	/* Hilite							*/
	/* Display the combobox with a list of possibleh ighlights	*/
	if (aName == "hilite")
	{
		TKTextEditorManager	*manager = getTextManager () ;
		QStringList	 	hlList	 = manager->highlightsNames() ;

		comboBox.clear () ;
		comboBox.insertItem	  ("")	   ;
		comboBox.insertStringList (hlList) ;

		for (int idx = 0 ; idx < comboBox.count() ; idx += 1)
			if (comboBox.text(idx) == item->value())
			{	comboBox.setCurrentItem(idx) ;
				break	;
			}

		comboBox.show  () ;
		return	true	  ;
	}

	return	KBItemPropDlg::showProperty (item) ;
}

/*  KBMemoPropDlg							*/
/*  saveProperty: Check and save attribute				*/
/*  item	: KBAttrItem *	: Associated item			*/
/*  (returns)	: bool		: Attribute OK				*/

bool	KBMemoPropDlg::saveProperty
	(	KBAttrItem	*item
	)
{
	const QString	&aName = item->attr()->getName () ;

	/* Hilite							*/
	/* Value is in the combo box					*/
	if (aName == "hilite")
	{
		setProperty (item, comboBox.currentText()) ;
		return	true	;
	}

	return	KBItemPropDlg::saveProperty (item) ;
}

/*  KBMemoPropDlg								*/
/*  hideProperty: Check whether property should be hidden		*/
/*  attr	: KBAttr *	: Attribute in question			*/
/*  (returns)	: void		:					*/

bool	KBMemoPropDlg::hideProperty
	(	KBAttr	*attr
	)
{
	const QString	&name	= attr->getName () ;

	if (name == "bgcolor") return true ;

	return	false	;
}


/*  memoPropDlg	: Run the memo properties dialog			*/
/*  memo	: KBMemo *	: Parent memo				*/
/*  caption	: const char *  : Dialog box caption			*/
/*  attribs	: QList<KBAttr>&: List of attributes			*/
/*  iniAttr	: cchar *	: Initial attribute			*/
/*  (returns)	: bool	  	: Success				*/

bool	memoPropDlg
	(	KBMemo		*memo,
		cchar		*caption,
		QList<KBAttr>	&attribs,
		cchar		*iniAttr
	)
{
	KBMemoPropDlg mDlg (memo, caption, attribs, iniAttr) ;
	return	mDlg.exec () ;
}
