/***************************************************************************
    file	         : kb_navigator.h
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#ifndef	__KB_NAVIGATOR_H
#define	__KB_NAVIGATOR_H

#include	"libkbase_exports.h"



/*  KBTabOrderList							*/
/*  --------------							*/
/*  Wrapper class for QList<KBObject> to provide an ordering function.	*/

class	LIBKBASE_API	KBTabOrderList	: public QList<KBObject>
{
protected :

	int	compareItems (QCollection::Item, QCollection::Item) ;

public	:

	KBObject	*getFirst (uint) ;
	KBObject	*getPrev  (uint) ;
	KBObject	*getNext  (uint) ;
	KBObject	*getLast  (uint) ;
}	;



/*  KBNavigator								*/
/*  -----------								*/
/*  This class is used to handle control navigation in forms. It is	*/
/*  separated out into a class since it is needed both for blocks and	*/
/*  for containers.							*/

class	LIBKBASE_API	KBNavigator
{
	KBObject	*m_owner	;
	KBFormBlock	*m_block	;
	QList<KBNode>	&m_childList	;

	KBGrid		*findGrid ()	;

protected :

	KBTabOrderList	m_tabList	;

public	:

	KBNavigator	(KBObject *, KBFormBlock *, QList<KBNode> &) ;

	void		fixGridLayout	()	;
	void		orderGridByExpr	(bool)	;

	void		fixTabOrder	()	;
#if	! __KB_RUNTIME
	bool		newTabOrder	()	;
#endif
	KBItem		*firstItem	()	;

	KBObject	*goNext		(KBObject *, bool) ;
	KBObject	*goPrevious	(KBObject *, bool) ;
	KBObject	*goFirst	(bool)	;
	KBObject	*goLast		(bool)	;

	bool		keyStroke	(KBItem *, QKeyEvent *) ;

	inline	KBTabOrderList	*getTabList ()
	{
		return	&m_tabList	;
	}

	static	bool	isNavKey	(QKeyEvent *) ;
}	;


#if	! __KB_RUNTIME

extern 	LIBKBASE_API	bool	tabOrderDlg 
			(	KBBlock 	*,
				QList<KBObject>	&
			)	;

#endif
#endif	// __KB_NAVIGATOR_H
