/***************************************************************************
    file	         : kb_plugins.cpp
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/


#include	"kb_classes.h"
#include	"kb_desktop.h"

#include	"libkbase_exports.h"

#include	"kb_locator.h"
#include	"kb_libloader.h"


#if		defined(_WIN32) || __KB_EMBEDDED
#define		DLERROR() 	""
#else
#include	<dlfcn.h>
#define		DLERROR()	dlerror()
#endif

#if		__KB_RUNTIME
#define		DTPREFIX	"rekallrt"
#define		DTTYPE		"RekallRT/Plugin"
#else
#define		DTPREFIX	"rekall"
#define		DTTYPE		"Rekall/Plugin"
#endif

typedef	void	*(*IFPROC)()	;

/*  loadRekallPlugins							*/
/*		: Locate and load plugins				*/
/*  (returns)	: void		:					*/

LIBKBASE_API
	void	loadRekallPlugins ()
{
	KBLibLoader	*loader	= KBLibLoader::self() ;

	/* Scan the local desktop files which descrive the rekall	*/
	/* "services". These are the same files as used for the KTrader	*/
	/* version, but the decoding in KBDesktop is much simplified.	*/
	QString		 dtDir	= locateDir
				  (	"appdata",
					"services/" DTPREFIX "_table.desktop"
				  )	;

	QList<KBDesktop> dtDefs		;

	KBDesktop::scan (dtDir + "/services", DTPREFIX "_", dtDefs) ;

	for (uint idx = 0 ; idx < dtDefs.count() ; idx += 1)
	{
		KBDesktop *desktop = dtDefs.at(idx) ;

		if (desktop->property ("ServiceTypes") != DTTYPE)
			continue	;

		// desktop->print () ;

		QString	libname	 = desktop->property("X-KDE-Library") ;
		KBLibrary *lib	 = loader->getLibrary(libname) ;

		if (lib == 0)
		{	
			fprintf
			(	stderr,
				"loadRekallPlugins: no library %s [%s]\n", 
				(cchar *)libname,
				(cchar *)loader->lastErrorMessage()
			)	;
			continue;
		}

		KBPartFactory	*factory = (KBPartFactory *)lib->factory() ;
		if (factory == 0)
		{	
			fprintf
			(	stderr,
				"loadRekallPlugins: cannot create factory %s\n",
				(cchar *)libname
			)	;
			continue;
		}

		/* Call the plugin factory's ::create method, but note	*/
		/* that we do not expect any results.			*/
		factory->create (0, 0, 0) ;

		// fprintf
		// (	stderr,
		// 	"loadRekallPlugins: returned from factory\n"
		// )	;
	}
}
