/***************************************************************************
    file	         : kb_qryquery.h
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#ifndef	 _KB_QRYQUERY_H
#define	 _KB_QRYQUERY_H

#include 	"kb_qrydata.h"
#include	"kb_docroot.h"

#include	"libkbase_exports.h"



/*  KBQryQuery								*/
/*  -----------								*/
/*  Class used for data queries which retrieve data via a KBase-level	*/
/*  query.								*/

class LIBKBASE_API	KBQryQuery : public KBQryData
{
	KBAttrStr	m_qryName	;
	KBAttrStr	m_qryWhere	;
	KBAttrStr	m_qryOrder	;
	KBAttrStr	m_qryGroup	;
	KBAttrStr	m_qryHaving	;
	KBAttrStr	m_topTable	;
	KBAttrUInt	m_limit		;

	KBQuery		*m_qryRoot	;

	QList<KBQryExpr>m_exprList 	;

	bool			loadQueryDef	() ;

protected :

	virtual	bool		loadQuery	() ;

#if	! __KB_RUNTIME
	virtual	bool		propertyDlg	() ;
#endif

public	:

	KBQryQuery	(KBNode *, const QDict<QString> &, bool * = 0) ;
	KBQryQuery	(KBNode *, KBQryQuery *) ;
	KBQryQuery	(KBNode *) ;

virtual~KBQryQuery	() ;

	virtual	KBQryQuery 	*isQryQuery	() { return this ; }

	virtual	KBNode		*replicate	(KBNode *) ;

	bool			loadQueryDef	(KBLocation &) ;
	bool			getLinkage	(uint, QString &, QString &) ;

	inline	QString		getQryName	()
	{
		return	m_qryName.getValue () ;
	}
	inline	QString		getTopTable	()
	{
		return	m_topTable.getValue () ;
	}

	virtual	bool		getFieldList	(uint, QList<KBFieldSpec> &, int &) ;
	virtual	QString		getComment	(uint)	;
}	;


/*  KBDummyRoot								*/
/*  -----------								*/
/*  This is used as a root node for a KBQryQuery when we need to run	*/
/*  the query outside a form or report. Nasty hack really!		*/

class	LIBKBASE_API KBDummyRoot : public KBNode
{
	KBDocRoot	m_docRoot	;

public	:

	inline	KBDummyRoot
		(	KBLocation	&location
		)
		:
		KBNode		(0, "KBDummyRoot"),
		m_docRoot	(this, children, location)
	{
	}

	virtual	KBDocRoot	*isDocRoot  () { return &m_docRoot ; }
}	;


#endif	// _KB_QRYQUERY_H
