/***************************************************************************
    file	         : kb_qtreplink.cpp
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#include	<stdio.h>
#include	<stdlib.h>
#include	<ctype.h>

#include	<qapplication.h>
#include	<qlist.h>
#include	<qstring.h>

#include	"kb_classes.h"
#include	"kb_type.h"
#include	"kb_value.h"

#include	"kb_writer.h"
#include	"kb_link.h"
#include	"kb_display.h"
#include	"kb_qtreplink.h"



/*  KBCtrlRepLink								*/
/*  KBCtrlRepLink: Constructor for combo box wrapper			*/
/*  display	 : KBDisplay *	 : Parent display			*/
/*  link	 : KBLink *	 : Parent link				*/
/*  drow	 : uint		 : Row number in field			*/
/*  (returns)	 : KBCtrlRepLink :					*/

KBCtrlRepLink::KBCtrlRepLink
	(	KBDisplay	*display,
		KBLink		*link,
		uint		drow
	)
	:
	TKLineEdit (display->getDisplayWidget()),
	KBControl  (this,  display, link, drow),
	link	   (link)
{
}

/*  KBCtrlRepLink								*/
/*  ~KBCtrlRepLink	: Desctructor for link class				*/
/*  (returns)	:		:					*/

KBCtrlRepLink::~KBCtrlRepLink ()
{
}

/*  KBCtrlRepLink								*/
/*  setData	: Set value set						*/
/*  data	: void *	: Actually KBLTValueSet *		*/
/*  (returns)	: void		:					*/

void	KBCtrlRepLink::setData
	(	void	*data
	)
{
	KBLinkData *ltd = (KBLinkData *)data ;
	m_valset = &ltd->m_valset ;
	clear 	      ()       ;
}

/*  KBCtrlRepLink							*/
/*  showName	: Show control name					*/
/*  (returns)	: void		:					*/

void	KBCtrlRepLink::showName ()
{
#if	! __KB_RUNTIME
	if ((m_drow == 0) && (m_showing == KB::ShowAsDesign))
		setText (link->getName()) ;
#endif
}

/*  KBCtrlRepLink								*/
/*  showAs	: Set or clear design mode				*/
/*  mode	: KB::ShowAs	: Design mode				*/
/*  (returns)	: void		:					*/

void	KBCtrlRepLink::showAs
	(	KB::ShowAs	mode
	)
{
	KBControl::showAs (mode) ;

	clear () ;

#if	! __KB_RUNTIME
	if ((mode == KB::ShowAsDesign) && (m_drow == 0))
	{	showName () ;
		return	 ;
	}
#endif
}

/*  KBCtrlRepLink								*/
/*  setValue	: Set value						*/
/*  value	: const KBValue &: Value				*/
/*  (returns)	: void		 :					*/

void	KBCtrlRepLink::setValue
	(	const KBValue	&value
	)
{
	setText	(link->valueToText (value)) ;
	KBControl::setValue (value) ;
}

/*  KBCtrlRepLink								*/
/*  getValue	: Get value						*/
/*  (returns)	: KBValue 	: Value					*/

KBValue	KBCtrlRepLink::getValue ()
{
	return	KBControl::getValue () ;
}

/*  KBCtrlRepLink								*/
/*  clearValue	: Get value						*/
/*  query	: bool		: Clear for query			*/
/*  (returns)	: KBValue 	: Value					*/

void	KBCtrlRepLink::clearValue
	(	bool	query
	)
{
	setText ("") ;
	KBControl::clearValue (query) ;
}

/*  KBCtrlRepLink								*/
/*  isEmpty	: See if control is empty				*/
/*  (returns)	: bool		: Empty					*/

bool	KBCtrlRepLink::isEmpty ()
{
	/* All entries are valid, and hence non-empty, unless there is	*/
	/* an "unset" value at the head of the list. Hence, empty is	*/
	/* the same as not-valid.					*/
	return	text().isEmpty() ;
}

/*  KBCtrlRepLink								*/
/*  giveFocus	: Give focus to the control				*/
/*  (returns)	: void							*/

void	KBCtrlRepLink::giveFocus ()
{
	TKLineEdit::setFocus () ;
}

/*  KBCtrlRepLink								*/
/*  write	: Write link 						*/
/*  writer	: KBWriter *	: Output writer				*/
/*  rect	: QRect		: Field area				*/
/*  value	: KBValue &	: Value for reports			*/
/*  fSubs	: bool		: Substitution flag			*/
/*  extra	: int &		: Return extra space			*/
/*  (returns)	: bool		: Success				*/

bool	KBCtrlRepLink::write
	(	KBWriter	*writer,
		QRect		rect,
		const KBValue	&value,
		bool		fSubs,
		int		&extra
	)
{
	if (writer->asReport())
	{
		new KBWriterText
		(	writer,
			rect,
			link->getPalette(true),
			link->getFont   (true),
			value.getRawText(),
			Qt::AlignLeft|Qt::AlignVCenter,
			false
		)	;
		extra	= 0	;
		return	true	;
	}

	return	KBControl::write (writer, rect, value, fSubs, extra) ;
}
