/***************************************************************************
    file	         : kb_qtsummary.cpp
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#include	<stdio.h>
#include	<stdlib.h>
#include	<ctype.h>

#include	<qapplication.h>
#include	<qlist.h>
#include	<qstring.h>
#include	<qcursor.h>

#include	"kb_classes.h"
#include	"kb_type.h"
#include	"kb_value.h"

#include	"kb_summary.h"
#include	"kb_display.h"
#include	"kb_qtsummary.h"
#include	"kb_writer.h"




/*  KBCtrlSummary								*/
/*  KBCtrlSummary: Constructor for summary line edit wrapper		*/
/*  display	 : KBDisplay *	 : Parent display			*/
/*  summary	 : KBSUmmary *	 : Parent summary control		*/
/*  drow	 : uint		 : Row number in control		*/
/*  (returns)	 : KBCtrlSummary :					*/

KBCtrlSummary::KBCtrlSummary
	(	KBDisplay	*display,
		KBSummary	*summary,
		uint		drow
	)
	:
	TKLineEdit	(display->getDisplayWidget()),
	KBControl	(this, display, summary, drow),
	m_summary	(summary)
{
}

/*  KBCtrlSummary							*/
/*  ~KBCtrlSummary: Destructor for summary class			*/
/*  (returns)	  :		:					*/

KBCtrlSummary::~KBCtrlSummary ()
{
}

/*  KBCtrlSummary							*/
/*  showName	: Show control name					*/
/*  (returns)	: void		:					*/

void	KBCtrlSummary::showName ()
{
#if	! __KB_RUNTIME
	if ((m_drow == 0) && (m_showing == KB::ShowAsDesign))
		setText (m_summary->getName()) ;
#endif
}

/*  KBCtrlSummary								*/
/*  showAs	: Set or clear design mode				*/
/*  mode	: KB::ShowAs	: Design mode				*/
/*  (returns)	: void		:					*/

void	KBCtrlSummary::showAs
	(	KB::ShowAs	mode
	)
{
	KBControl::showAs (mode) ;

#if	! __KB_RUNTIME
	if (mode == KB::ShowAsDesign)
	{
		if (m_drow == 0) setCursor (QCursor(Qt::arrowCursor)) ;
		showName () ;
		return	 ;
	}
#endif

	setCursor (QCursor(Qt::ibeamCursor)) ;
	setText   ("")	;
}

/*  KBCtrlSummary								*/
/*  write	: Write field 						*/
/*  writer	: KBWriter *	: Output writer				*/
/*  rect	: QRect		: Field area				*/
/*  value	: KBValue &	: Value for reports			*/
/*  extra	: int &		: Return extra space			*/
/*  fSubs	: bool		: Substitution flag			*/
/*  (returns)	: bool		: Success				*/

bool	KBCtrlSummary::write
	(	KBWriter	*writer,
		QRect		rect,
		const KBValue	&value,
		bool		fSubs,
		int		&extra
	)
{
	if (writer->asReport())
	{
		new KBWriterText
		(	writer,
			rect,
			m_summary->getPalette(true),
			m_summary->getFont   (true),
			value.isNull () ?
				QString::null :
				value.getText(m_summary->getFormat()),
			m_summary->getAlign  ()|Qt::AlignVCenter,
			fSubs
		)	;

		extra	= 0	;
		return	true	;
	}

	return	KBControl::write (writer, rect, value, fSubs, extra) ;
}
