/***************************************************************************
    file	         : kb_rowmark.h
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#ifndef	_KB_ROWMARK_H
#define	_KB_ROWMARK_H


#include	"kb_classes.h"
#include	"kb_item.h"
#include	"kb_attrframe.h"

#include	"libkbase_exports.h"

/*  KBRowMarkData							*/
/*  -------------							*/
/*  A whole bunch of settings are passed to the rowmark control via the	*/
/*  ::setData method and an instance of the KBRowMarkData structure.	*/
/*  There is no really good reason for this, maybe we should have a set	*/
/*  of data-specific methods, since rowmarks are handled specially in	*/
/*  any case.								*/

struct LIBKBASE_API	KBRowMarkData
{
	enum	Type
	{	State,
		Current,
		InBlock,
		RowNo,
		Marked
	}	;

	Type	type	;

	union
	{	KB::RState	state	;
		bool		current	;
		bool		inBlock	;
		uint		rowNo	;
	}	;
}	;

/*  KBRowMark								*/
/*  ---------								*/
/*  This class is used to represent a KBaseRowMark element in the XML	*/
/*  form description. Note that it may map onto more than one actual	*/
/*  field.								*/

class	LIBKBASE_API	KBRowMark : public KBItem
{
	Q_OBJECT

	KBAttrStr	bgcolor	;	/* Background colour		*/
	KBAttrFrame	frame	;	/* Frame specification		*/
	KBAttrBool	showRow	;	/* Show row number		*/
	KBEvent		dblClick;	/* Double click event		*/
	uint		rcRow	;

protected :

	virtual	KBControl *makeCtrl    (uint)	;

#if	! __KB_RUNTIME
	virtual	bool	propertyDlg	() ;
#endif

public	:

	KBRowMark	(KBNode  *, const QDict<QString> &, bool * = 0) ;
	KBRowMark	(KBNode  *, KBRowMark *) ;
virtual~KBRowMark	() ;

	virtual	KBRowMark *isRowMark () { return this ; }

	virtual	void	contextMenu	(QMouseEvent *, uint) ;

	virtual	KBNode	*replicate	(KBNode   *) ;
	virtual void	setCurrent  	(uint, bool) ;
	virtual void	setState	(uint, KB::RState) ;
	virtual	void	setInBlock	(bool)	;

	virtual	void	setTabOrder	(int)	;
	virtual	int	getTabOrder	()	;

	inline	bool	getShowRow	()
	{
		return	showRow.getBoolValue()	;
	}

	void		setRowMarked	(uint, KB::MarkOp) ;
	void		doubleClick	(uint)	;

public	slots :

	void		insertRow	() ;
	void		deleteRow	() ;
	void		markSetAll	() ;
	void		markClearAll	() ;
}	;


#if	! __KB_RUNTIME
extern LIBKBASE_API	bool	rowMarkPropDlg
			(	KBRowMark	*,
				cchar		*,
				QList<KBAttr>	&
			)	;
#endif
#endif	// _KB_ROWMARK_H
