/***************************************************************************
    file	         : kb_summary.h
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#ifndef	_KB_SUMMARY_H
#define	_KB_SUMMARY_H

#include	"kb_classes.h"
#include	"kb_item.h"
#include	"kb_attralign.h"

#include	"libkbase_exports.h"



/*  KBSummary								*/
/* --- ------								*/
/*  This class is used to represent a KBSummary element in the XML of a	*/
/*  form description.							*/

class LIBKBASE_API	KBSummary : public KBItem
{
	KBAttrStr	fgcolor	;	/* Foreground (text) colour	*/
	KBAttrStr	bgcolor	;	/* Background colour		*/
	KBAttrStr	font	;	/* Font specification		*/
	KBAttrStr	format	;	/* Format string		*/
	KBAttrAlign	align	;	/* Alignment			*/
	KBAttrStr	summary	;	/* Summary to be done		*/
	KBAttrBool	reset	;	/* Page reset flag		*/

	KBReport	*report	;	/* Embedding report		*/

	int		iVal		;
	double		dVal		;
	QString		sVal		;
	int		iValPrior	;
	double		dValPrior	;
	QString		sValPrior	;

	uint		nVals	;	/* Number of values		*/

	void		sumUnknown		(const KBValue &) ;
	void		sumSumInt		(const KBValue &) ;
	void		sumSumDouble		(const KBValue &) ;
	void		sumMaxInt		(const KBValue &) ;
	void		sumMaxDouble		(const KBValue &) ;
	void		sumMinInt		(const KBValue &) ;
	void		sumMinDouble		(const KBValue &) ;
	void		(KBSummary::*sumFunc)	(const KBValue &) ;

protected :

	virtual	KBControl 	*makeCtrl	(uint)	   ;
	virtual	void		setFieldType	(KBType *) ;

#if	! __KB_RUNTIME
	virtual	bool	 	propertyDlg	(cchar  *) ;
#endif

public	:

	KBSummary	(KBNode  *, const QDict<QString> &, bool * = 0) ;
	KBSummary  (KBNode  *, KBSummary *) ;
virtual~KBSummary	() ;

	virtual	KBNode		*replicate	(KBNode *) ;
	virtual	void		showAs		(KB::ShowAs) ;
	virtual	bool		setValue 	(uint, const KBValue &) ;
	virtual	KBValue		getReportValue	(bool, bool = false) ;
	virtual	void		prepare		() ;

	inline	QString	getFormat ()
	{
		return	format.getValue() ;
	}
	inline	int	getAlign  ()
	{
		return	align.getIntValue() ;
	}
}	;


#if	! __KB_RUNTIME
extern	LIBKBASE_API	bool	summaryPropDlg
			(	KBSummary	*,
				cchar		*,
				QList<KBAttr>	&,
				cchar		* = 0
			)	;
#endif
#endif	// _KB_SUMMARY_H
