/***************************************************************************
    file	         : tk_action.h
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#ifndef	__TK_ACTION_H
#define	__TK_ACTION_H

#include	<kdeversion.h>
#include 	<kaction.h>
#include	<kurl.h>

class		TKConfig	;

class	TKURL : public KURL
{
public	:

	TKURL	(const KURL &url) ;
}	;


/*  TKAction								*/
/*  --------								*/
/*  Wrapper class round KAction, adds a code which is an argument to	*/
/*  the "activated" signal, and a group identifier			*/

class	TKAction : public QObject
{
	Q_OBJECT

signals :

	void	activated (int) ;

protected :

	int		code	;
	int		group	;
	KAction		*action	;

	void	setAction		(KAction *) ;

protected slots :

	virtual	void	slotActivated	() ;

public	:

	TKAction
	(	const QString	&text,
		const QString	&iconName,
		int		accel,
		const QObject	*receiver,
		const char	*slot,
		QObject		*parent,
		const char 	*name = 0
	)	;

	TKAction
	(	const QObject	*receiver,
		const char	*slot,
		QObject		*parent,
		const char	*name
	)	;

	TKAction
	(	QObject		*parent,
		const char	*name
	)	;

	TKAction
	(	KAction		*action,
		QObject		*parent,
		const char	*name	= 0
	)	;

	virtual		~TKAction	()	;

	KAction		*getAction 	()	;
	int		getGroup 	()	;

	void		setCode		(int)	;
	void		setGroup	(int)	;
	void		setToolTip	(const QString &) ;
	void		setEnabled	(bool)	;

	void		unplugAll	()	;

	inline	QString	text	()
	{
		return	action->text	() ;
	}
}	;


/*  TKToggleAction								*/
/*  --------------								*/
/*  Wrapper class round KToggleAction, adds a code which is an argument	*/
/*  to the "activated" signal, and a group identifier			*/

class	TKToggleAction : public TKAction
{
	Q_OBJECT

protected :

	KToggleAction	*toggleAction	;

protected slots :

	void	slotToggled	(bool)	;

signals	:

	void	toggled		(bool, int) ;

public	:

	TKToggleAction
	(	const QString	&text,
		const QString	&iconName,
		int		accel,
		const QObject	*receiver,
		const char	*slot,
		QObject		*parent,
		const char 	*name = 0
	)	;

	KToggleAction	*getToggleAction	()	;
	void		setChecked		(bool)	;
	bool		isChecked		()	;
}	;


class	TKSelectAction : public TKAction
{
	Q_OBJECT

protected :

	KSelectAction		*selectAction	;

public	:

	TKSelectAction
	(	const QString	&text,
		const QString	&iconName,
		int		accel,
		const QObject	*receiver,
		const char	*slot,
		QObject		*parent,
		const char 	*name = 0
	)	;

	void		setItems	(const QStringList &) ;	
	void		setCurrentItem	(int) ;
	QPopupMenu	*popupMenu	() ;
}	;

/*  TKRecentFilesAction							*/
/*  -------------------							*/
/*  Wrapper class round KRecentFilesAction, passes back the url wrapped	*/
/*  up as a TKURL							*/

class	TKRecentFilesAction : public TKAction
{
	Q_OBJECT

protected :

	KRecentFilesAction	*recentAction	;

protected slots :

	void	slotUrlSelected	(const KURL  &)	;

signals	:

	void	urlSelected	(const TKURL &) ;

public	:

	TKRecentFilesAction
	(	const QString	&text,
		const QString	&iconName,
		int		accel,
		const QObject	*receiver,
		const char	*slot,
		QObject		*parent,
		const char 	*name = 0
	)	;

	void	loadEntries	(TKConfig *) ;
	void	saveEntries	(TKConfig *) ;
	void	addURL		(const TKURL &) ;
	void	removeURL	(const TKURL &) ;
	void	setCurrentItem	(int) ;
}	;


/*  TKActionMenu							*/
/*  ------------							*/
/*  Wrapper round a KActionMenu.					*/

class	TKActionMenu : public TKAction
{
	KActionMenu	*actionMenu	;

public	:

	TKActionMenu	(const QString &, QObject *, const char *) ;

	void	insert	(TKAction *, int = -1) ;
	void	remove	(TKAction *) ;
}	;


#if	!((KDE_VERSION_MAJOR == 3) && (KDE_VERSION_MINOR == 0))

class	TKWidgetAction : public TKAction
{
	KWidgetAction	*widgetAction	;
	KShortcut	shortcut	;

public	:

	TKWidgetAction	(QWidget *, QObject *, const char *)	;
}	;

#endif

#endif	// __TK_ACTION_H
