/***************************************************************************
    file	         : tk_icons.cpp
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#include	<qstring.h>
#include	<qimage.h>
#include	<qpixmap.h>
#include	<qfileinfo.h>
#include	<qdict.h>

#include	"tk_header.h"

#include 	"libtkkde_exports.h"



static	QDict<QPixmap>	pixMapDict		;
extern	const QString	&getAppdataDir	()	;

static	QString	findIconPath
	(	const char	*size,
		const QString	&name
	)
{

	static	const	char	*paths[] =
	{
		"icons" SEPSTR "hicolor" SEPSTR "%1" SEPSTR "actions" SEPSTR "%1.png",
		"icons" SEPSTR "hicolor" SEPSTR "%1" SEPSTR "apps"    SEPSTR "%1.png",
		0
	}	;

	for (const char **pp = &paths[0] ; *pp != 0 ; pp += 1)
	{
		QString	  path = getAppdataDir() + '/' + QString(*pp).arg(size).arg(name) ;

		QFileInfo file(path)	;
		if (file.exists ())
		{
			return path ;
		}
	}

	return	QString::null ;
}

static	QPixmap	loadPixmapPNG
	(	const QString	&path
	)
{
	QPixmap	*cached	= pixMapDict.find (path) ;
	if (cached != 0) return *cached ;

	QPixmap	pixmap	;
	pixmap.convertFromImage (QImage(path));
	pixMapDict.insert (path, new QPixmap (pixmap)) ;
	return	pixmap	;
}

static	QPixmap	loadPixmapXPM
	(	const char	**xpm
	)
{
	QPixmap	pixmap	;
	pixmap.convertFromImage (QImage(xpm)) ;
	return	pixmap	;
}



LIBTKKDE_API QPixmap	getDesktopIcon
	(	const QString	&name
	)
{
	QString	path	= findIconPath ("48x48", name) ;
	return	path.isNull() ? QPixmap () : loadPixmapPNG (path) ;
}

LIBTKKDE_API QPixmap	getBarIcon
	(	const QString	&name
	)
{
	QString	path	= findIconPath ("22x22", name) ;
	return	path.isNull() ? QPixmap () : loadPixmapPNG (path) ;
}

LIBTKKDE_API QPixmap	getSmallIcon
	(	const QString	&name
	)
{
	QString	path	= findIconPath ("16x16", name) ;
	return	path.isNull() ? QPixmap () : loadPixmapPNG (path) ;
}
