/***************************************************************************
    file	         : tk_mainwindow.h
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#ifndef	__TK_MAINWINDOW_H
#define	__TK_MAINWINDOW_H

#include	<qmainwindow.h>

#include	"tk_action.h"
#include	"tk_menubar.h"
#include	"tk_xmlguispec.h"
#include	"tk_part.h"

#include "libtkkde_exports.h"

/*  TKMainWindow							*/
/*  ------------							*/
/*  This class is used as a KMainWindow equivalent for the QT-only	*/
/*  versions of Rekall. It also contains some functionality which is	*/
/*  dependant on whether this is the embedded version or Rekall or not.	*/

class LIBTKKDE_API TKMainWindow : public QMainWindow, virtual public TKXMLGUISpec
{
	Q_OBJECT

	QToolBar		*m_toolBar	;
	TKMenuBar		*m_menuBar	;
	QWidget			*m_centralWidget;
	TKAction		*m_dummy	;
#if	__KB_EMBEDDED
	TKActionMenu		*m_fileMenu	;
#endif
	bool			m_inShow	;
	bool			m_shown		;
	QRect			m_maxGeom	;

protected :

	TKMenuBar		*menuBar	() ;
	QToolBar		*toolBar	() ;

	virtual	void		closeEvent	(QCloseEvent *) ;
	virtual	bool		queryClose	() ;
	virtual	bool		queryExit	() ;

public slots :

	virtual	void		createGUI	(TKPart *) ;

public	:

	TKMainWindow (QWidget * = 0, const char * = 0, WFlags = WType_TopLevel|WDestructiveClose) ;

	int			menuBarHeight	()	;
	int			toolBarHeight	()	;
	virtual void		show		()	;
	void			show		(bool)	;
	void		showMenuToolBars(bool, bool)	 ;

}	;


#endif	// __TK_MAINWINDOW_H
