/***************************************************************************
    file	         : tk_print.h
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#ifndef	__TK_PRINT_H
#define	__TK_PRINT_H

#include	"qdom.h"
#include	"qvaluelist.h"
#include	"qprinter.h"

#include	"libtkkde_exports.h"


struct	LIBTKKDE_API	TKPrinterSettings
{
	QPrinter::ColorMode	m_colorMode		;
	int			m_numCopies		;
	QPrinter::Orientation	m_orientation		;
	QString			m_outputFileName	;
	bool			m_outputToFile		;
	QPrinter::PageOrder	m_pageOrder		;
	QPrinter::PageSize	m_pageSize		;
	QString			m_printProgram		;
	QString			m_printerName		;
	QString			m_printerSelectionOption;
}	;

class	LIBTKKDE_API	TKPrinter : public QPrinter
{
public	:
	enum	Resolution
	{
		ResScreen	= 0,
		ResPrinter	= 1,
		ResHigh		= 2
	}	;

	TKPrinter (Resolution, TKPrinterSettings * = 0)	;

	void		loadSettings	(QDomElement &) ;
	void		saveSettings	(QDomElement &) ;
	void		saveSettings	(TKPrinterSettings &) ;

	bool		setup		() ;
	void		restore		() ;

	QValueList<int>	pageList	() const ;
}	;

#endif	// __TK_PRINT_H

