/***************************************************************************
    file	         : tk_xmlguispec.cpp
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#include	<stdio.h>

#define		INCLUDE_MENUITEM_DEF

#include	<qfile.h>
#include	<qmenudata.h>
#include	<qpopupmenu.h>
#include	<qobjectlist.h>

#include	"tk_toolbutton.h"
#include	"tk_action.h"
#include	"tk_xmlguispec.h"



/*  TKXMLGUISpec							*/
/*  TKXMLGUISpec: Constructor for XML GUI specification object		*/
/*  (returns)	: TKXMLGUISpec	:					*/

TKXMLGUISpec::TKXMLGUISpec ()
{
	m_XMLSpecs.setAutoDelete (true) ;
	m_collection = 0 ;
}

/*  TKXMLGUISpec							*/
/*  ~TKXMLGUISpec: Destructor for XML GUI specification object		*/
/*  (returns)	 :		:					*/

TKXMLGUISpec::~TKXMLGUISpec ()
{
	if (m_collection != 0) delete m_collection ;
}

/*  TKXMLGUISpec							*/
/*  actionCollection							*/
/*		: Get action collection for this GUI specification	*/
/*  (returns)	: TKActionCollection * : The collection			*/

TKActionCollection
	*TKXMLGUISpec::actionCollection ()
{
	if (m_collection == 0) m_collection = new TKActionCollection () ;
	return	m_collection ;
}

/*  TKXMLGUISpec							*/
/*  setXMLFile	: Load XML specification file				*/
/*  xmlName	: const QString & : Specification file name		*/
/*  merge	: bool		  : Merge with existing			*/
/*  (returns)	: bool		  : Success				*/

bool	TKXMLGUISpec::setXMLFile
	(	const QString	&_xmlName,
		bool		merge
	)
{
	QString	xmlName	= _xmlName ;

#ifdef	_WIN32
	xmlName	= "rekallui_" + xmlName.mid (9) ;
#endif

	if (!merge)
		m_XMLSpecs.clear () ;

	QFile	xmlFile (xmlName) ;
	if (!xmlFile.open (IO_ReadOnly))
	{
		xmlFile.setName (getAppdataDir() + '/' + xmlName) ;
		if (!xmlFile.open (IO_ReadOnly))
		{
			fprintf
			(	stderr,
				"setXMLSpec: %s: cannot open [%s]\n",
				(const char *)xmlName,
				(const char *)(getAppdataDir() + '/' + xmlName)
			) ;
			return	false	;
		}
	}

	QDomDocument	*XMLSpec = new QDomDocument () ;
	if (!XMLSpec->setContent (&xmlFile))
	{
		delete	XMLSpec	;
		fprintf	(stderr, "setXMLSpec: %s: cannot load\n",
				 (const char *)xmlName) ;
		return	false	;
	}

	m_XMLSpecs.append (XMLSpec) ;
	return	true ;
}

/*  TKXMLGUISpec							*/
/*  action	: Locate specified action				*/
/*  menuElement	: const QDomElement & : XML definition element		*/
/*  (returns)	: TKAction *	      : Action or null if not found	*/

TKAction*TKXMLGUISpec::action
	(	const QDomElement &menuElement
	)
	const
{
	QString	 name	 = menuElement.attribute ("name") ;
	TKAction *action = m_collection->action  (name  ) ;

	if (action == 0)
		fprintf	(stderr, "Action %s not found\n", (const char *)name) ;

	return	 action ;
}

/*  TKXMLGUISpec							*/
/*  action	: Locate specified action				*/
/*  name	: const char *	      : Action name			*/
/*  (returns)	: TKAction *	      : Action or null if not found	*/

TKAction*TKXMLGUISpec::action
	(	const char	*name
	)
	const
{
	TKAction *action = m_collection->action  (name  ) ;

	if (action == 0)
		fprintf	(stderr, "Action %s not found\n", (const char *)name) ;

	return	 action ;
}

/*  TKXMLGUISpec							*/
/*  findPopup	: Find named popup menu amongst menu data		*/
/*  menu	: QMenuData *	  : Menu data				*/
/*  name	: const QString & : Required popup name			*/
/*  (returns)	: QPopupMenu *	  : Popup menu or null if not found	*/

QPopupMenu
	*TKXMLGUISpec::findPopup
	(	QMenuData	*menu,
		const QString	&name
	)
{
//	fprintf	(stderr, "findPopup: %s\n", (const char *)name) ;

	QMenuItem	*item	;
	QPopupMenu	*popup	= 0 ;

	/* Scan for the popup. This is tedious since we cannot get the	*/
	/* entry at an index directly; rather we have to go via the	*/
	/* identifiers.							*/
	for (uint idx = 0 ; idx < menu->count() ; idx += 1)
		if ((item = menu->findItem(menu->idAt(idx))) != 0)
			if ((item->popup() != 0) && (item->popup()->name() == name))
			{	popup	= item->popup () ;
				break	;
			}

	return	popup	;
}

/*  TKXMLGUISpec							*/
/*  buildMenuPopup							*/
/*		: Build a popup menu under an extant popup menu		*/
/*  menuPopup	: QPopupMenu *	       : Extant popup			*/
/*  menuElement	: const QDomElement &  : XML definition element		*/
/*  (returns)	: void		       :				*/

void	TKXMLGUISpec::buildMenuPopup
	(	QPopupMenu		*menuPopup,
		const QDomElement	&menuElement
	)
{
	QDomNodeList nodes = menuElement.childNodes() ;

	for (unsigned int idx = 0 ; idx < nodes.length() ; idx += 1)
	{
		QDomElement element = nodes.item(idx).toElement() ;
		if (element.isNull()) continue ;

		if (element.tagName() == "Menu")
		{
			QString	    name   = element.attribute("name") ;
			QDomElement title  = element.namedItem("text").toElement() ;

			if (name.isEmpty() || title.isNull()) continue ;

			QPopupMenu  *popup = findPopup (menuPopup, name) ;
			if (popup == 0)
			{	popup	= new QPopupMenu (menuPopup, name) ;
				menuPopup->insertItem (title.text(), popup) ;
			}

			buildMenuPopup (popup, element) ;
			continue ;
		}

		if (element.tagName() == "Action")
		{
			TKAction *_action = action (element) ;
			if (_action != 0) _action->plug (menuPopup) ;
			continue ;
		}
	}
}

/*  TKXMLGUISpec							*/
/*  buildMenuBar: Build a top-level menu bar				*/
/*  menuBar	: QMenuBar *	       : Menu bar in question		*/
/*  menuElement	: const QDomElement &  : XML definition element		*/
/*  (returns)	: void		       :				*/

void	TKXMLGUISpec::buildMenuBar
	(	QMenuBar		*menuBar,
		const QDomElement	&menuElement
	)
{
	QDomNodeList nodes = menuElement.childNodes() ;

	for (unsigned int idx = 0 ; idx < nodes.length() ; idx += 1)
	{
		QDomElement element = nodes.item(idx).toElement() ;
		if (element.isNull()) continue ;

		if (element.tagName() == "Menu")
		{
			QString	    name   = element.attribute("name") ;
			QDomElement title  = element.namedItem("text").toElement() ;

			if (name.isEmpty() || title.isNull()) continue ;

			QPopupMenu  *popup = findPopup (menuBar, name) ;
			if (popup == 0)
			{	popup	= new QPopupMenu (menuBar, name) ;
				menuBar->insertItem (title.text(), popup) ;
			}

			buildMenuPopup (popup, element) ;
		}

		/* Unlike ::buildMenuPopup, we don't have anything	*/
		/* other than submenus at this level.			*/
	}
}

/*  TKXMLGUISpec							*/
/*  buildToolBar: Build a tool bar					*/
/*  toolBar	: QToolBar *	       : Tool bar in question		*/
/*  menuElement	: const QDomElement &  : XML definition element		*/
/*  (returns)	: void		       :				*/

void	TKXMLGUISpec::buildToolBar
	(	QToolBar		*toolBar,
		const QDomElement	&toolElement
	)
{
	QDomNodeList nodes = toolElement.childNodes() ;


	for (unsigned int idx = 0 ; idx < nodes.length() ; idx += 1)
	{
		QDomElement element = nodes.item(idx).toElement() ;
		if (element.isNull()) continue ;

		if (element.tagName() == "Action")
		{
			TKAction  *_action = action (element) ;
			if (_action != 0) _action->plug (toolBar) ;
			continue ;
		}
		if (element.tagName() == "Popup")
		{
			TKActionMenu  *_action = new TKActionMenu
						 (	element.attribute ("text"),
							0,
							element.attribute ("name")
						 )	;
			_action->setIcon (element.attribute("icon")) ;
			_action->plug    (toolBar) ;

			buildMenuPopup (_action->popup(), element) ;
			continue ;
		}

	}
}

/*  TKXMLGUISpec							*/
/*  buildGUI	: Build GUI from XML specification			*/
/*  menuBar	: QMenuBar *	       : Menu bar			*/
/*  toolBar	: QToolBar *	       : Tool bar			*/
/*  (returns)	: void		       :				*/

void	TKXMLGUISpec::buildGUI
	(	QMenuBar		*menuBar,
		QToolBar		*toolBar
	)
{
	actionCollection () ;

	for (QDomDocument *XMLSpec  = m_XMLSpecs.first() ;
			   XMLSpec != 0 ;
			   XMLSpec  = m_XMLSpecs.next ())
	{
		QDomElement	root	= XMLSpec->documentElement() ;

		if (menuBar != 0)
			buildMenuBar (menuBar, root.namedItem ("MenuBar").toElement()) ;

		if (toolBar != 0)
			buildToolBar (toolBar, root.namedItem ("ToolBar").toElement()) ;
	}

}
/*  TKXMLGUISpec							*/
/*  buildGUI	: Build GUI from XML specification			*/
/*  menuPopup	: QPopupMenu *	       : Popup menu			*/
/*  toolBar	: QToolBar *	       : Tool bar			*/
/*  (returns)	: void		       :				*/

void	TKXMLGUISpec::buildGUI
	(	QPopupMenu		*menuPopup,
		QToolBar		*toolBar
	)
{
	actionCollection () ;

	for (QDomDocument *XMLSpec  = m_XMLSpecs.first() ;
			   XMLSpec != 0 ;
			   XMLSpec  = m_XMLSpecs.next ())
	{
		QDomElement	root	= XMLSpec->documentElement() ;

		if (menuPopup != 0)
			buildMenuPopup (menuPopup, root.namedItem ("MenuBar").toElement()) ;

		if (toolBar   != 0)
			buildToolBar   (toolBar,   root.namedItem ("ToolBar").toElement()) ;
	}
}


static	QString	appdataDir	;

LIBTKKDE_API
	void	setAppdataDir
	(	const QString	&dir
	)
{
	appdataDir	= dir	;
}

LIBTKKDE_API
	const QString &getAppdataDir	()
{
	return	appdataDir ;
}

