/*
    Copyright (C) 2001-2002 by theKompany.com <www.thekompany.com>
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
    See COPYING.GPL file.

    In addition, as a special exception, theKompany.com gives permission
    to link the code of this program with the tkwidgets library (or with
    modified versions of tkwidgets that use the same license as tkwidgets),
    and distribute linked combinations including the two.  You must obey
    the GNU General Public License in all respects for all of the code used
    other than tkwidgets.  If you modify this file, you may extend this
    exception to your version of the file, but you are not obligated to do so.
    If you do not wish to do so, delete this exception statement from your
    version.

    This license grants you the ability to use tkwidgets with Rekall only
    and may not be used outside of Rekall.
    See also http://www.rekall.a-i-s.co.uk/products/license.txt for details.
*/


#ifndef TKTEXTDOCUMENT_H
#define TKTEXTDOCUMENT_H

#ifdef _WIN32
#pragma warning(disable : 4251)
#endif

#include <qobject.h>
#include <qtextstream.h>

#include "tktextaction.h"
#include "tktextview.h"

#if QT_VERSION >= 300
#include <qptrlist.h>
#include <qptrstack.h>
#include <qmemarray.h>
#else
#include <qlist.h>
#include <qstack.h>
#include <qarray.h>
#define QPtrList QList
#define QPtrStack QStack
#define QMemArray QArray
#endif

#include	"libtkwidgets_exports.h"

class LIBTKWIDGETS_API  TKTextEditorManager;
class LIBTKWIDGETS_API  TKTextHighlightManager;
class LIBTKWIDGETS_API  TKTextHighlight;
class LIBTKWIDGETS_API  TKTextLine;

class LIBTKWIDGETS_API  TKTextLineArray : public QMemArray<TKTextLine *>
{
public:
  TKTextLineArray();

  TKTextLine *line(int);

  void setAutoDelete(bool);

  void append(TKTextLine *);
  void insert(int index, TKTextLine *);
  void remove(int index);

  void clear();

private:
  bool autoDelete;
};

class LIBTKWIDGETS_API  TKTextDocument : public QObject
{ Q_OBJECT
friend class TKTextView;
friend class TKTextEditor;
friend class TKLinuNumberMargin;
public:
  enum wrapMode { wrapLine, wrapWord };
  TKTextDocument(TKTextEditorManager *);
  ~TKTextDocument();

  TKTextEditorManager *textManager() const { return m; }

  bool isModified() { return modified; }

  void clear();
  bool load(QTextStream &);
  bool save(QTextStream &);
  bool saveWith6Numbers(QTextStream &);

  QString text();
  void setReadOnly(bool);
  bool isReadOnly();

  int lineHeight() const;
  int lastLine() const;
  TKTextLine *lineOf(int line);
  int lineNum(int line);
  int lineCol(int line, int column);

  void tagLine(int line);
  void tagLines(int start, int end);
  void tagAll();


  void setMarked(int, int);
  int marked(int);
  void setHighlight(TKTextHighlight *);
  void setHighlight(const QString &);
  TKTextHighlight *highlight() { return hl; }
  void setCustomHighlight(const QString & = QString::null);

  void setWrap(bool);
  bool getWrap();
  wrapMode getWrapMode();
	
  void paintEmptyArea(TKTextView *, const QRect &);
  void paintLine(TKTextView *, int line);
  QString html(int line);

  int linePosition(int line);
  int lineNumber(int y);

  int lineWidth(TKTextLine *);
  int textWidth(int line, int length);
  int textWidth(int line, int from, int to);
  int wrappedWidth(TKTextView * view, int line, int length);
  int wrappedHeight(TKTextView * view, int line, int column);

  int textLength(int line);
  int textLength(int line, int width);

  int documentWidth();
  int documentHeight();

  void makeFold(TKTextView *, int fromLine, int toLine);
  void fold(TKTextView *, int line);

  void indent(TKTextView *);
  void unindent(TKTextView *);

  bool canRedo();
  bool canUndo();

  void updateViews();
  void updateFontData();

  void lockRecordStart(bool);
  void lockRecordEnd(bool);

  void setWordBound(QString b);
  QString getWordBound();
  void setWrapMode(enum wrapMode);

protected:
  TKTextEditorManager *m;

  enum SelectionCommand {
    SelectionCopy = 1,
    SelectionRemove = 2,
    SelectionCut = SelectionCopy | SelectionRemove,
    SelectionText = 4
  };
  QString selectionCommand(TKTextView *, SelectionCommand);
  QString selectionCommand(TKTextView *, SelectionCommand, const QRect &, bool);

  void renumLines(int start, bool internal);

public:

  void append(const QString &);
  void insert(TKTextView *, const QString &, int line=0, int column=0);
  void insertLineBreak(TKTextView *, int line=0, int column=0);
  void removeLine(TKTextView *, int line=0, int column=0);
  void backspace(TKTextView *, int line=0, int column=0);
  void del(TKTextView *, int line=0, int column=0);
  void qwrap(TKTextView *, int line=0, int column=0);
  int  wrap(TKTextView *, int line, int * vl, int *vc);
  int  unwrap(TKTextView *, int line, int * vl, int *vc);
  void rewrap(TKTextView *);

  void registerView(TKTextView *);
  void removeView(TKTextView *);

  void setTabWidth(int);

  void updateLine(int line);
  void updateLines(int startLine, int endLine);
  void updateLines();

  void updateMaxLength(TKTextLine *);

  void resizeBuffer();

  uint viewsCount();

  void insertLine(int);
  void removeLine(int);
  void foldLine(int);
  void unfoldLine(int);

  TKTextLineArray contents;
  TKTextLineArray rcontents;
  TKTextHighlight *hl;

  int tabChars;
  int tabWidth;
  int tabsWidth;
  int fontHeight;
  int fontWidth;
  int fontAscent;

  QPtrList<TKTextView> views;
  bool newDocGeometry;

  TKTextLine *longestLine;
  int maxLength;

  bool modified;

  QPtrList<TKEditorActionGroup> undoList;
  int currentUndo;
  int undoSteps;

  LineRegion updateRegion;
  QPainter *paint;
  QPixmap *buffer;

  void doActionGroup(TKEditorActionGroup *);
  void doAction(TKEditorAction *);
  void undo(TKTextView *);
  void redo(TKTextView *);
  void setUndoSteps(int steps);

  void recordStart(int line, int column);
  void recordEnd(TKTextView *, int line, int column);

  void documentChanged(bool);

  QPtrStack<TKEditorAction> *actionsStack;

  bool readonly;

  bool startRecordLock;
  bool endRecordLock;
  bool shouldWrap;
  wrapMode nWrapMode;
  QString wordBound;
};

inline int TKTextDocument::lineHeight() const
{ return fontHeight; }

inline int TKTextDocument::linePosition(int line)
{ return line * fontHeight; }

inline int TKTextDocument::lineNumber(int y)
{ return y / lineHeight(); }

inline QString TKTextDocument::getWordBound()
{ return wordBound; }

inline TKTextDocument::wrapMode TKTextDocument::getWrapMode()
{ return nWrapMode; }


#endif
