/*
    Copyright (C) 2001-2002 by theKompany.com <www.thekompany.com>
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
    See COPYING.GPL file.

    In addition, as a special exception, theKompany.com gives permission
    to link the code of this program with the tkwidgets library (or with
    modified versions of tkwidgets that use the same license as tkwidgets),
    and distribute linked combinations including the two.  You must obey
    the GNU General Public License in all respects for all of the code used
    other than tkwidgets.  If you modify this file, you may extend this
    exception to your version of the file, but you are not obligated to do so.
    If you do not wish to do so, delete this exception statement from your
    version.

    This license grants you the ability to use tkwidgets with Rekall only
    and may not be used outside of Rekall.
    See also http://www.rekall.a-i-s.co.uk/products/license.txt for details.
*/


#ifndef TKTEXTMANAGER_H
#define TKTEXTMANAGER_H

#ifdef _WIN32
#pragma warning(disable : 4251)
#endif

#include <qobject.h>
#include <qcolor.h>
#include <qfont.h>
#include <qfontmetrics.h>
#include <qptrdict.h>

#include "libtkwidgets_exports.h"

#include "tktextdoc.h"
#include "tktexteditor.h"

#if QT_VERSION >= 300
#include <qptrlist.h>
#else
#include <qlist.h>
#define QPtrList QList
#endif

class TKTextEditor;


class LIBTKWIDGETS_API  TKTextEditor;
/*
class LIBTKWIDGETS_API  TKTextMarginManager
{
public:
  TKTextMarginManager();
  virtual ~TKTextMarginManager();

  virtual QPixmap icon(int) = 0;
};
*/
class LIBTKWIDGETS_API  TKTextEditorManager : public QObject
{ Q_OBJECT
public:
  TKTextEditorManager();
  ~TKTextEditorManager();

  TKTextEditor* createEditor(QWidget *parent=0, TKTextDocument *doc=0, const char *name=0);
  void addEditor(TKTextEditor *editor, TKTextDocument *doc=0);
  void editorActivated(TKTextEditor *);

  QStringList highlightsNames();

  bool overwriteMode();
  bool isIndicatorMarginVisible();
#ifdef KOBOL
	int runLine();
	void setRunLine(int l);
#else
	bool isLinuNumberMarginVisible();
#endif
  bool isSelectionMarginVisible();
  int  tabWidth();
  void updateHighlight();

public slots:
  void setOverwriteMode(bool);
  void setIndicatorMarginVisible(bool);
  void setLinuNumberMarginVisible(bool);
  void setSelectionMarginVisible(bool);
  void setVerticalSelection(bool);
  void setTabWidth(int);

signals:
  void activate(TKTextEditor *);
  void overwriteModeChanged();

protected slots:
  void docDestroyed();
  void editorDestroyed();
/*****************************************************************************************/
public:
  void setResourcesDir(const QString &);
  QString resourcesDir();

  void setLocalResourcesDir(const QString &);
  QString localResourcesDir();

  virtual void setHlSettingsKey(const QString &);
  QString hlSettingsKey();

  QFont font() { return fnt; }
  int width(int type, QChar &);
  int width(int type, const QString &);
	QFont &font(int type) const;
  void setFont(const QFont &);
  void updateMarginsState();

  bool fCursorWrap;
  bool fSaveTab;
  bool fVerticalSelection;
  bool fOvr;
  bool fAutoIndent;
  bool fRemoveSpaces;
  bool fBackspaceIndent;
  bool fSmartHome;

  bool fIndicatorMargin;
  bool fSelectionMargin;
#ifndef KOBOL
  bool fLinuNumberMargin;
#else
	int  run_line;
  bool fLinuNumberMarginZero;
#endif

  QRect margins;
  int printWidth;
  int tabWidthValue;
  QString resDir;
  QString localResDir;
  QString hlSettings;

  QColor normalBackgroundColor;
  QColor selectedBackgroundColor;
  QColor foundBackgroundColor;

#ifdef QT_NO_CLIPBOARD
  QString clipboard
;
#endif

#ifndef QT_NO_PRINTER
  QPrinter *printer;
#endif
  bool setupPrinter();
  void setMargins(const QRect &);

//  void registerMarginManager(TKTextMarginManager *);
//  void unregisterMarginManager(TKTextMarginManager *);
//  QPixmap marginIcon(int classId, int itemId);
//  int textMarginClassId(TKTextMarginManager *);

private:

  QPtrList<TKTextDocument> documents;
  QPtrList<TKTextEditor> editors;
//  QPtrDict<TKTextMarginManager> marginManagers;
  QFont fnt;

  struct FontData
  {
		FontData() : font(0), fm(0), width(-1) {};
		~FontData() { delete fm; delete font; }

		void set(const QFont &f, bool bold, bool italic)
		{
			delete fm;
			delete font;
			font = new QFont(f);
			font->setBold(bold);
			font->setItalic(italic);
			fm = new QFontMetrics(*font);
      if ((width = fm->width('W')) != fm->width('i')) width = -1;
		}
		QFont *font;
		QFontMetrics *fm;
		int width;
  };
  FontData fonts[4];
};

#endif
