/***************************************************************************
    file	         : kb_wizfields.cpp
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#include	"kb_classes.h"
#include	"kb_database.h"
#include	"kb_dblink.h"
#include	"kb_location.h"
#include	"kb_qryquery.h"


#include	"kb_wizsource.h"

#ifndef		_WIN32
#include	"kb_wizfields.moc"
#else
#include	"kb_wizfields.h"
#endif


KBWizFieldSpec::KBWizFieldSpec
	(	QListBox	*parent,
		KBFieldSpec	*fSpec
	)
	:
	QListBoxText (parent, fSpec->m_name),
	KBFieldSpec  (*fSpec)
{
}

KBWizFieldSpecList::KBWizFieldSpecList
	(	QListBox	*source,
		QListBox	*dest,
		QPushButton	*bAdd,
		QPushButton	*bAddAll,
		QPushButton	*bRemove,
		QPushButton	*bUp,
		QPushButton	*bDown,
		bool		multi
	)
	:
	KBListBoxPair (source, dest, bAdd, bAddAll, bRemove, bUp, bDown, multi)
{
}

QListBoxItem
	*KBWizFieldSpecList::replicate
	(	QListBoxItem	*item
	)
{
	return	new KBWizFieldSpec (0, (KBFieldSpec *)(KBWizFieldSpec *)item) ;
}


/*  ------------------------------------------------------------------  */

/*  KBWizardCtrlFields							*/
/*  KBWizardCtrlFields							*/
/*		: Constructor for data source wizard control		*/
/*  page	: KBWizardPage *	 : Parent page			*/
/*  elem	: QDomElement  &	 : Definition element		*/
/*  (returns)	: KBWizardCtrlFields :					*/

KBWizardCtrlFields::KBWizardCtrlFields
	(	KBWizardPage		*page,
		const QDomElement	&elem
	)
	:
	KBWizardCtrl	(page, elem.attribute("name"))
{
	/* The "source" attribute should have the form "page.ctrl"	*/
	/* and names the control (which should actually be of class	*/
	/* "KBWizardCtrlDataSource") that specifies the source for the	*/
	/* fields.							*/
	m_sourceName	= elem.attribute  ("source") ;

	setWide		(true) ;
	setWidget	(m_widget = new QWidget (page)) ;

	m_source	= new QListBox	  (m_widget) ;
	m_dest		= new QListBox	  (m_widget) ;
	m_bAdd		= new QPushButton (m_widget) ;
	m_bAddAll	= new QPushButton (m_widget) ;
	m_bRemove	= new QPushButton (m_widget) ;
	m_bMoveUp	= new QPushButton (m_widget) ;
	m_bMoveDown	= new QPushButton (m_widget) ;

	QVBoxLayout	*layMain = new QVBoxLayout (m_widget) ;

	layMain->addWidget (m_source	) ;

	QGridLayout	*layButt = new QGridLayout (layMain ) ;

	layButt->addWidget (m_bAdd,	 0, 0) ;
	layButt->addWidget (m_bAddAll,	 0, 1) ;
	layButt->addWidget (m_bRemove,	 1, 0) ;
	layButt->addWidget (m_bMoveUp,	 0, 3) ;
	layButt->addWidget (m_bMoveDown, 1, 3) ;
	layButt->setColStretch (2, 1) ;

	layMain->addWidget (m_dest	) ;

	m_lbPair = new	KBWizFieldSpecList
			(	m_source,
				m_dest,
				m_bAdd,
				m_bAddAll,
				m_bRemove,
				m_bMoveUp,
				m_bMoveDown,
				false
			)	;

	connect
	(	m_lbPair,
		SIGNAL	(destChanged(bool)),
		SLOT	(ctrlChanged())
	)	;
}

/*  KBWizardCtrlFields							*/
/*  ~KBWizardCtrlFields							*/
/*		: Destructor for data source wizard control		*/
/*  (returns)	:		:					*/

KBWizardCtrlFields::~KBWizardCtrlFields ()
{
	delete	m_lbPair ;
}

/*  KBWizardCtrlFields							*/
/*  pageShown	: Page containing control is shown			*/
/*  next	: bool		: Moving to next page			*/
/*  (returns)	: void		:					*/

void	KBWizardCtrlFields::pageShown
	(	bool		next
	)
{
	/* Do nothing if moving backwards. The field list will not	*/
	/* have changed and this preserves the user selection.		*/
	if (!next) return ;

	KBWizard	*wizard	= page()->wizard() ;

	QStringList	source	= QStringList::split ('.', m_sourceName) ;
	KBWizardCtrl	*ctrl	= wizard->findCtrl   (source[0], source[1]) ;

	m_source->clear() ;
	m_dest  ->clear() ;
	m_lbPair->setButtonState() ;

	if (ctrl == 0)
	{
		KBError::EError
		(	TR("Cannot locate source control"),
			QString("Path '%1'").arg(m_sourceName),
			__ERRLOCN
		)	;
		return	;
	}

	KBWizardCtrlDataSource::Type type =
		(KBWizardCtrlDataSource::Type)ctrl->attribute("type").toUInt() ;

	/* First case is the source is a table, in which case query the	*/
	/* database to get a list of the columns in the table. Add	*/
	/* these to the source list.					*/
	if (type == KBWizardCtrlDataSource::Table)
	{
		KBTableSpec 	tabSpec (ctrl->value()) ;
		KBDBLink    	dbLink  ;

		if (!dbLink.connect (wizard->dbInfo(), wizard->server()))
		{	dbLink.lastError().DISPLAY() ;
			return	;
		}

		if (!dbLink.listFields (tabSpec))
		{	dbLink.lastError().DISPLAY() ;
			return	;
		}

		LITER
		(	KBFieldSpec,
			tabSpec.m_fldList,
			fldSpec,

			new KBWizFieldSpec (m_source, fldSpec) ;
		)
	}

	/* Second case is a query, in which case we need to load the	*/
	/* query definition and get the field list from that.		*/
	if (type == KBWizardCtrlDataSource::Query)
	{
		KBLocation	locn
				(	wizard->dbInfo(),
					"query",
					wizard->server(),
					ctrl  ->value ()
				)	;

		KBDummyRoot	dummy (locn) ;

		KBQryQuery *qry	 = new KBQryQuery (&dummy) ;

		if (!qry->loadQueryDef (locn))
		{
			qry->lastError().DISPLAY() ;
			return	;
		}

		QList<KBFieldSpec> fldList ;
		int		   pKey	   ;
		fldList.setAutoDelete (true) ;

		if (!qry->getFieldList (0, fldList, pKey))
		{
			qry->lastError().DISPLAY() ;
			return	;
		}

		LITER
		(	KBFieldSpec,
			fldList,
			fldSpec,

			new KBWizFieldSpec (m_source, fldSpec) ;
		)
	}

	/* Initialise the button state. Do it this way so that the	*/
	/* code is all in one place, even though the initial settings	*/
	/* should always be the same.					*/
	m_lbPair->setButtonState() ;
}

/*  KBWizardCtrlFields							*/
/*  setValue	: Set data value					*/
/*  value	: const QString & : Value to set			*/
/*  (returns)	: void		  :					*/

void	KBWizardCtrlFields::setValue
	(	const QString	&
	)
{
	/* Not used! Anyway, it is a bit meaningless since we'd need	*/
	/* the name *and* the type.					*/
}

/*  KBWizardCtrlFields							*/
/*  value	: Get value						*/
/*  (returns)	: QString	: Value					*/

QString	KBWizardCtrlFields::value ()
{
	return	QString::null	;
}

/*  KBWizardCtrlFields							*/
/*  attribute	: Get attribute value					*/
/*  attr	: const QString & : Attribute to retrieve		*/
/*  (returns)	: QVariant	  :					*/

QVariant
	KBWizardCtrlFields::attribute
	(	const QString	&attr
	)
{
	if (attr == "fields")
	{
		QStringList fields	;
		for (uint idx = 0 ; idx < m_dest->count() ; idx += 1)
			fields.append (m_dest->text(idx)) ;
		return	QVariant (fields) ;
	}

	return	QVariant() ;
}

/*  KBWizardCtrlFields							*/
/*  ok		: Check if settings are acceptable			*/
/*  (returns)	: bool		: Acceptable				*/

bool	KBWizardCtrlFields::ok ()
{
	return	m_dest->count() > 0 ;
}

/*  KBWizardCtrlFields							*/
/*		: Get list of field specification			*/
/*  list	: QList<KBFieldSpec> &	: List to set			*/
/*  (returns)	: void			:				*/

void	KBWizardCtrlFields::fields
	(	QList<KBFieldSpec>	&list
	)
{
	for (uint idx = 0 ; idx < m_dest->count() ; idx += 1)
		list.append ((KBFieldSpec *)(KBWizFieldSpec *)m_dest->item(idx)) ;
}


WIZARDCTRLREG(Fields)
