/***************************************************************************
    file	         : kb_copierbase.cpp
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#include	<qwidget.h>

#include	"kb_classes.h"
#include	"kb_type.h"
#include	"kb_value.h"
#include	"kb_dbinfo.h"
#include	"kb_location.h"
#include	"kb_viewer.h"
#include	"kb_build.h"

#include	"kb_copywidget.h"
#include	"kb_copier.h"

#include	"kb_objbase.h"
#include	"kb_copierlist.h"

#ifndef		_WIN32
#include	"kb_copierbase.moc"
#else
#include	"kb_copierbase.h"
#endif


/*  KBCopierBase:							*/
/*  KBCopierBase: Constructor for base object for data copier		*/
/*  parent	: QObject *	: Parent object				*/
/*  (returns)	: KBCopier	:					*/

KBCopierBase::KBCopierBase
	(	QObject		*parent
	)
	:
	KBObjBase (parent)
{
	m_copier = 0 ;
}

/*  KBCopierBase :							*/
/*  ~KBCopierBase: Destructor for base object for data copier	*/
/*  (returns)	 :		:					*/

KBCopierBase::~KBCopierBase ()
{
}

/*  KBCopierBase:							*/
/*  build	: Build an instance of an object			*/
/*  location	: KBLocation &	  : Object location			*/
/*  create	: bool		  : Creating a new object		*/
/*  pError	: KBError &	  : Error return			*/
/*  (returns)	: bool		  :					*/

bool	KBCopierBase::build
	(	KBLocation	&location,
		bool		create,
		KBError		&pError
	)
{
	setLocation (location) ;

	if (!create)
	{
		if (!getLocation().contents (m_doc, pError))
			return	false	;
	}

	return	true	;
}

/*  KBCopierBase:							*/
/*  show	: Show editor						*/
/*  _mode	: QString	  : Initial display mode		*/
/*  pDict	: QDict<QString>& : Parameter dictionary		*/
/*  embed	: QWidget *	  : Widget into which to embed display	*/
/*  pError	: KBError &	  : Error return			*/
/*  key		: const KBValue & : Parent key				*/
/*  rDict	: QDict<QString>* : Results dictionary			*/
/*  (returns)	: KB::ShowRC	  : Success				*/

KB::ShowRC
	KBCopierBase::show
	(	KB::ShowAs		showAs,
		const QDict<QString>	&,
		QWidget			*embed,
		KBError			&pError,
		const KBValue		&,
		QDict<QString>		*
	)
{
	if (m_copier == 0)
	{
		m_copier = new KBCopier (this, embed) ;
		setPart	(m_copier, false) ;

		KB::ShowRC rc = m_copier->startup (m_doc, showAs, pError) ;
		if (rc != KB::ShowRCOK)
		{
			delete	m_copier;
			return	rc	;
		}

		return	KB::ShowRCOK	;
	}

	m_copier->widget()->setFocus()	;
	m_copier->showAs(showAs)	;
	return	KB::ShowRCOK ;
}

QString	KBCopierBase::def ()
{
	return	m_copier->def() ;
}

void	KBCopierBase::widgetClosing ()
{
}

/*  -----------------------------------------------------------------  */

KBFACTORYIMPL
(	KBCopierFactory,
	copierview,
	"Rekall copier viewer",
	"Plugin",
	"0",
	"7",
	"0"
)


QObject	*KBCopierFactory::create
	(	QObject		  *parent,
		cchar		  *name,
		cchar		  *className,
		const QStringList &
	)
{
	if ((className != 0) && (strcmp (className, "browser") == 0))
		return	new KBCopierList ((QWidget *)parent, (KBDBInfo *)name) ;

	return	new	KBCopierBase (parent) ;
}

cchar	*KBCopierFactory::ident ()
{
	return	__KB_BUILD_IDENT	;
}
