/***************************************************************************
    file	         : kb_copywidget.cpp
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#include	<qtabwidget.h>
#include	<qtabbar.h>

#include	"kb_classes.h"
#include	"kb_type.h"
#include	"kb_value.h"
#include	"kb_location.h"
#include	"kb_dblink.h"

#ifndef 	_WIN32
#include	"kb_copywidget.moc"
#else
#include	"kb_copywidget.h"
#endif

#include	"kb_tablewidget.h"
#include	"kb_filewidget.h"
#include	"kb_xmlwidget.h"
#include	"kb_sqlwidget.h"
#include	"kb_querywidget.h"


/*  KBCopyWidget							*/
/*  KBCopyWidget: Copier source/destination widget constructor		*/
/*  parent	: QWidget *	: Parent widget				*/
/*  part	: QObject *	: Parent copier part			*/
/*  srce	: bool		: Souce, else destination		*/
/*  location	: KBLocation &	: Database location			*/
/*  (returns)	: KBCopyWidget	:					*/

KBCopyWidget::KBCopyWidget
	(	QWidget		*parent,
		QObject		*part,
		bool		srce,
		KBLocation	&location
	)
	:
	QTabWidget	(parent),
	srce		(srce),
	location	(location)
{
	cpTable	= new KBTableWidget (this, part, srce, location) ;
 	cpFile	= new KBFileWidget  (this, part, srce, location) ;
	cpXML	= new KBXMLWidget   (this, part, srce, location) ;

	addTab (cpTable, new QTab(TR("Table"))) ;
	addTab (cpFile,  new QTab(TR("File"))) ;
	addTab (cpXML,   new QTab(TR("XML"))) ;
	
	copiers.append (cpTable) ;
	copiers.append (cpFile ) ;
	copiers.append (cpXML  ) ;

	if (srce)
	{
		cpSQL	= new KBSQLWidget  (this, part, srce, location) ;
		addTab	(cpSQL, new QTab(TR("SQL"))) ;
		copiers.append (cpSQL) ;

		cpQuery	= new KBQueryWidget (this, part, srce, location) ;
		addTab	(cpQuery, new QTab(TR("Query"))) ;
		copiers.append (cpQuery) ;
	}

	connect
	(	this,
		SIGNAL(currentChanged(QWidget *)),
		part,
		SLOT  (setChanged())
	)	;
}

/*  KBCopyWidget							*/
/*  ~KBCopyWidget: Copier source/destination widget destructor		*/
/*		 :		:					*/

KBCopyWidget::~KBCopyWidget ()
{
}

/*  KBCopyWidget							*/
/*  valid	: Check validity					*/
/*  error	: KBError &	 : Error return				*/
/*  (returns)	: bool		 : Success				*/
 
bool	KBCopyWidget::valid
	(	KBError		&error
	)
{
	return	copiers.at(currentPageIndex())->valid(error) ;
}

/*  KBCopyWidget							*/
/*  def		: Retrieve definition of current state			*/
/*  root	: QDomElement & : Node to which to attach		*/
/*  (returns)	: void		:					*/
 
void	KBCopyWidget::def
	(	QDomElement	&root
	)
{
	QDomElement	copy	;

	copy = root.ownerDocument().createElement (srce ? "srce" : "dest") ;
	root.appendChild (copy)	;

	copy.setAttribute ("tag", copiers.at (currentPageIndex())->tag()) ;

	for (uint idx = 0 ; idx < copiers.count() ; idx += 1)
		copiers.at(idx)->def (copy) ;
//	cpTable->def (copy)	;
//	cpFile ->def (copy)	;

//	if (srce) cpSQL->def (copy) ;
}

/*  KBCopyWidget							*/
/*  set		: Set from XML definition				*/
/*  root	: QDomElement &	: Root element for definitions		*/
/*  pError	: KBError &	: Error return				*/
/*  (returns)	: bool		: Success				*/

bool	KBCopyWidget::set
	(	QDomElement	&root,
		KBError		&pError
	)
{
	QDomElement	copy	= root.namedItem(srce ? "srce" : "dest").toElement () ;

	if (copy.isNull ())
	{
		pError	= KBError
			  (	KBError::Error,
				QString("Document lacks %1 part").arg(srce ? "source" : "destination"),
				QString::null,
				__ERRLOCN
			  )	;
		return	false	;
	}

	for (uint idx1 = 0 ; idx1 < copiers.count() ; idx1 += 1)
		if (!copiers.at(idx1)->set (copy, pError)) return false ;

//	if (!cpTable->set (copy, pError)) return false ;
//	if (!cpFile ->set (copy, pError)) return false ;

//	if (srce)
//		if (!cpSQL->set (copy, pError)) return false ;

	QString	 tag	= copy.attribute("tag") ;
	for (uint idx2 = 0 ; idx2 < copiers.count() ; idx2 += 1)
		if (tag == copiers.at(idx2)->tag())
			setCurrentPage (idx2) ;

	return	true	;
}

/*  KBCopyWidget							*/
/*  getCopier	: Get copier for selected tab				*/
/*  (returns)	: KBCopyBase *	: Copier base				*/

KBCopyBase *KBCopyWidget::getCopier ()
{
	return	copiers.at (currentPageIndex()) ;
}
