/***************************************************************************
    file	         : kb_filewidget.cpp
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#include	<stdlib.h>

#include	<qapp.h>
#include	<qdom.h>


#include	"kb_classes.h"
#include	"kb_type.h"
#include	"kb_value.h"
#include	"kb_dialog.h"
#include	"kb_location.h"

#include	"kb_dbinfo.h"
#include	"kb_dblink.h"
#include	"kb_serverinfo.h"
#include	"kb_fieldchooser.h"

#ifndef 	_WIN32
#include	"kb_filewidget.moc"
#else
#include 	"kb_filewidget.h"
#endif

#include	"tk_icons.h"
#include	"tk_filedialog.h"



/*  KBFileWidget								*/
/*  KBFileWidget: Constructor for file copier widget			*/
/*  parent	: QWidget *	: Parent widget				*/
/*  part	: QObject *	: Parent copier part			*/
/*  srce	: bool		: File is source			*/
/*  location	: KBLocation &	: Database location			*/
/*  (returns)	: KBTableWidget	:					*/

KBFileWidget::KBFileWidget
	(	QWidget		*parent,
		QObject		*part,
		bool		srce,
		KBLocation	&location
	)
	:
	QWidget		(parent),
	KBCopyFile	(srce, location),
	m_part		(part),
	m_srce		(srce),
	m_location	(location),
	m_cbFixedDelim	(this),
	m_cbHeader	(this),
	m_spHeader	(this),
	m_typeStack	(this),

	m_gbDelim	(2, Qt::Horizontal, TR("Delimited"),   &m_typeStack),
	m_gbFixed	(1, Qt::Horizontal, TR("Fixed"),       &m_typeStack),
	m_gbFile	(3, Qt::Horizontal, TR("File/Error"),  this),

	m_wDelim	(&m_gbDelim),
	m_wFixed	(&m_gbFixed),
	m_wFile		(&m_gbFile),

	m_cbDelim	(&m_wDelim),
	m_cbQualif	(&m_wDelim),
	m_leCopyList	(&m_wDelim),

	m_fixedCols	(true, &m_wFixed),
	m_bTable	(&m_wFixed),
	m_bSample	(&m_wFixed),

	m_eFile		(&m_wFile),
	m_bBrowse	(&m_wFile),
	m_cbErrOpt	(&m_wFile)
{
	QVBoxLayout *layMain	= new QVBoxLayout (this) ;

	layMain->addWidget (&m_cbFixedDelim) ;

	QHBoxLayout *layHdr	= new QHBoxLayout (layMain) ;
	QLabel	    *shl	= new QLabel	  (TR("Skip lines"), this) ;
	shl->setAlignment (Qt::Right) ;

	layHdr ->addWidget (&m_cbHeader    ) ;
	layHdr ->addWidget (shl		   ) ;
	layHdr ->addWidget (&m_spHeader    ) ;

	if (!srce)
	{	shl->setEnabled	     (false) ;
		m_spHeader.setEnabled(false) ;
	}

	m_spHeader.setRange (0, 999999     ) ;

	layMain->addWidget (&m_typeStack   ) ;
	layMain->addWidget (&m_gbFile	   ) ;

	QGridLayout *layDelim	= new QGridLayout (&m_wDelim) ;
	QLabel	    *l1		= new QLabel	  (&m_wDelim) ;
	QLabel	    *l2		= new QLabel	  (&m_wDelim) ;
	QLabel	    *l3		= new QLabel	  (&m_wDelim) ;

	l1->setText	(TR("Delimiter")) ;
	l2->setText	(TR("Qualifier")) ;
	l3->setText	(TR("Copy list")) ;

	layDelim->addWidget (l1,	    0, 0) ;
	layDelim->addWidget (&m_cbDelim,    0, 1) ;
	layDelim->addWidget (l2,  	    1, 0) ;
	layDelim->addWidget (&m_cbQualif,   1, 1) ;
	layDelim->addWidget (l3,  	    2, 0) ;
	layDelim->addMultiCellWidget (&m_leCopyList, 2, 2, 1, 2) ;

	l3         ->setEnabled (m_srce) ;
	m_leCopyList.setEnabled (m_srce) ;

	QGridLayout *layFixed	= new QGridLayout (&m_wFixed) ;
	layFixed->addMultiCellWidget (&m_fixedCols, 0, 0, 0, 1) ;
	layFixed->addWidget (&m_bTable,   1, 0) ;
	layFixed->addWidget (&m_bSample,  1, 1) ;

	QHBoxLayout *layFile 	= new QHBoxLayout (&m_wFile) ;
	layFile ->addWidget (&m_eFile   ) ;
	layFile ->addWidget (&m_bBrowse ) ;
	layFile ->addWidget (&m_cbErrOpt) ;

	_KBDialog::setupLayout  (layMain,  -1, -1) ;
	_KBDialog::setupLayout  (layDelim, -1, -1) ;
	_KBDialog::setupLayout  (layFixed, -1, -1) ;
	_KBDialog::setupLayout  (layFile,  -1, -1) ;


	m_cbFixedDelim	.insertItem (TR("Delimited")) ;
	m_cbFixedDelim	.insertItem (TR("Fixed"    )) ;
	m_cbHeader    	.setText    (TR("File has column headers")) ;

	m_cbDelim	.insertItem ("," ) ;
	m_cbDelim	.insertItem (";" ) ;
	m_cbDelim	.insertItem (":" ) ;
	m_cbDelim	.insertItem ("|" ) ;
	m_cbDelim	.insertItem ("<tab>") ;
	m_cbDelim	.setEditable(true) ;

	m_cbQualif    	.insertItem (""  ) ;
	m_cbQualif    	.insertItem ("\"") ;
	m_cbQualif    	.insertItem ("'" ) ;
	m_cbQualif    	.setEditable(true) ;

	m_cbErrOpt    	.insertItem (m_srce ? TR("Ignore excess") : TR("Pad with nulls")) ;
	m_cbErrOpt    	.insertItem (TR("Skip line" )) ;
	m_cbErrOpt    	.insertItem (TR("Abort copy")) ;

	connect
	(	&m_cbFixedDelim,
		SIGNAL(activated     (int)),
		SLOT  (fixedSelected (int))
	)	;

	connect (&m_cbDelim,    SIGNAL(textChanged (const QString &)), part, SLOT(setChanged())) ;
	connect (&m_cbQualif,   SIGNAL(textChanged (const QString &)), part, SLOT(setChanged())) ;
	connect (&m_leCopyList, SIGNAL(textChanged (const QString &)), part, SLOT(setChanged())) ;
	connect (&m_cbHeader,   SIGNAL(toggled     (bool)), 	       part, SLOT(setChanged())) ;
	connect (&m_spHeader,   SIGNAL(valueChanged(int)), 	       part, SLOT(setChanged())) ;


	m_fixedCols.addColumn (TR("Index" )) ;
#if	__KB_EMBEDDED
	m_fixedCols.addColumn (TR("Name"  ), 112) ;
#else
	m_fixedCols.addColumn (TR("Name"  ), 170) ;
#endif
	m_fixedCols.addColumn (TR("Offset")) ;
	m_fixedCols.addColumn (TR("Width" )) ;
	m_fixedCols.addColumn (TR("Strip" )) ;

	m_bBrowse  .setPixmap (getSmallIcon("browse")) ;
	m_bTable   .setText   (TR("Set from table")) ;
	m_bSample  .setText   (TR("Set from sample")) ;

	new KBEditListViewItem (&m_fixedCols, "0") ;

	connect	(&m_fixedCols, SIGNAL(changed (uint,uint)), part, SLOT(setChanged ())) ;
	connect	(&m_fixedCols, SIGNAL(inserted(uint)),      part, SLOT(setChanged ())) ;
	connect	(&m_fixedCols, SIGNAL(deleted (uint)),      part, SLOT(setChanged ())) ;
	connect	(this, 	       SIGNAL(changed ()),          part, SLOT(setChanged ())) ;

	connect	(&m_bBrowse,   SIGNAL(clicked()), SLOT(clickBrowse())) ;
	connect	(&m_bTable,    SIGNAL(clicked()), SLOT(clickTable ())) ;
	connect	(&m_bSample,   SIGNAL(clicked()), SLOT(clickSample())) ;

	m_gbFile   .setFixedHeight (m_gbFile.sizeHint().height()) ;
	m_typeStack.addWidget  (&m_gbDelim) ;
	m_typeStack.addWidget  (&m_gbFixed) ;

	m_cbDelim .lineEdit()->setMaxLength (1) ;
	m_cbQualif.lineEdit()->setMaxLength (1) ;

	m_fixedCols.setEditType (4, KBEditListView::EdCheckBox) ;
}

/*  KBFileWidget							*/
/*  saveall	: Save all settings to copy object			*/
/*  (returns)	: void		:					*/

void	KBFileWidget::saveall ()
{
	reset	  () ;

	setWhich   (m_cbFixedDelim.currentItem()) ;
	setErrOpt  (m_cbErrOpt    .currentItem()) ;
	setDelim   (m_cbDelim     .currentText()) ;
	setQualif  (m_cbQualif    .currentText()) ;
	setCopyList(m_leCopyList  .text	      ()) ;
	setFile	   (m_eFile       .text	      ()) ;
	setHeader  (m_cbHeader    .isChecked  (), m_spHeader.value()) ;

	for (QListViewItem *item  = m_fixedCols.firstChild() ;
			    item != 0 ;
			    item  = item->nextSibling())
		if (!item->text(2).isEmpty() && !item->text(3).isEmpty())
			addField
			(	item->text(1),
				item->text(2).toUInt(),
				item->text(3).toUInt(),
				item->text(4) == "Yes"
			) ;
}

/*  KBFileWidget							*/
/*  error	: KBError &	 : Error return				*/
/*  (returns)	: bool		 : Success				*/

bool	KBFileWidget::valid
	(	KBError		&error
	)
{
	saveall	() ;
	return	KBCopyFile::valid (error) ;
}

/*  KBFileWidget								*/
/*  set		: Set copier from definition				*/
/*  copy	: QDomElement & : Definition parent			*/
/*  error	: KBError &	: Error return				*/
/*  (returns)	: bool		: Success				*/

bool	KBFileWidget::set
	(	QDomElement	&copy,
		KBError		&error
	)
{
	if (!KBCopyFile::set (copy, error)) return false ;

	m_cbFixedDelim.setCurrentItem  (getWhich() == 0 ? 0 : 1) ;
	fixedSelected 		       (getWhich() == 0 ? 0 : 1) ;

	m_cbDelim   .lineEdit()->setText (getDelim   ()) ;
	m_cbQualif  .lineEdit()->setText (getQualif  ()) ;
	m_leCopyList.setText		 (getCopyList()) ;
	m_cbErrOpt  .setCurrentItem      (getErrOpt  ()) ;

	uint		skip	;
	m_cbHeader  .setChecked	         (getHeader  (skip)) ;
	m_spHeader  .setValue		 (skip) ;

	uint		idx	;
	QString		name	;
	uint		offset	;
	uint		width	;
	bool		strip	;
	QListViewItem	*last	= 0 ;

	m_fixedCols.clear () ;

	for (idx = 0 ; getField (idx, name, offset, width, strip) ; idx += 1)
		last	= new KBEditListViewItem
			  (	&m_fixedCols,
				last,
				QString("%1").arg(idx),
				name,
				QString("%1").arg(offset),
				QString("%1").arg(width ),
				strip ? "Yes" : "No"
			  )	;
	new	KBEditListViewItem (&m_fixedCols, last, QString("%1").arg(idx)) ;

	m_eFile.setText (getFile ()) ;

	return	true	;
}

/*  KBFileWidget							*/
/*  def		: Get file copy definition				*/
/*  copy	: QDomElement &	: Element to which to attach		*/
/*  (returns)	: void		:					*/

void	KBFileWidget::def
	(	QDomElement	&copy
	)
{
	saveall	() ;
	return	KBCopyFile::def (copy) ;
}

/*  KBFileWidget							*/
/*  fixedSelected: User changes fixed/delimited setting			*/
/*  index	 : int		: Selected item				*/
/*  (returns)	 : void		:					*/

void	KBFileWidget::fixedSelected
	(	int	index
	)
{
	if (index == 0)
		m_typeStack.raiseWidget (&m_gbDelim) ;
	else	m_typeStack.raiseWidget (&m_gbFixed) ;

	emit changed () ;
}

/*  KBFileWidget							*/
/*  clickBrowse	: User clicks browse button				*/
/*  (returns)	: void		:					*/

void	KBFileWidget::clickBrowse ()
{
	QString	name	;

	if (m_srce)
		name	= KBFileDialog::getOpenFileName
			  (	QString::null,
			  	"*.txt|Text files\n*.csv|CSV files\n*.*|All files",
			  	qApp->activeWindow(),
			  	TR("Source File")
			  )	;
	else	name	= KBFileDialog::getSaveFileName
			  (	QString::null,
			  	"*.txt|Text files\n*.csv|CSV files\n*.*|All files",
			  	qApp->activeWindow(),
			  	TR("Destination File")
			  )	;

	if (!name.isEmpty())
	{	m_eFile.setText (name) ;
		emit changed  ()     ;
	}
}

/*  KBFileWidget							*/
/*  clickTable	: User clicks table button				*/
/*  (returns)	: void		:					*/

void	KBFileWidget::clickTable ()
{

	KBFieldChooserDlg fDlg (m_location, true, !m_srce) ;

	if (!fDlg.exec()) return ;

	QString		svrName	= fDlg.getServer () ;
	QString		tabName	= fDlg.getObject () ;
	QStringList	fields	= fDlg.getFields () ;

	KBTableSpec 	tabSpec (tabName) ;
	KBDBLink    	dbLink  ;

	if (!dbLink.connect (m_location, svrName))
	{	dbLink.lastError().DISPLAY() ;
		return	;
	}

	if (!dbLink.listFields (tabSpec))
	{	dbLink.lastError().DISPLAY() ;
		return	;
	}

	QListViewItem	*last	= 0 ;
	uint		colno 	= 0 ;
	uint		offset	= 0 ;

	m_fixedCols.clear () ;

	for (uint idx = 0 ; idx < fields.count() ; idx += 1)
	{
		QString	field	= *fields.at(idx) ;

		LITER
		(
			KBFieldSpec,
			tabSpec.m_fldList,
			fldSpec,

			if (fldSpec->m_name == field)
			{
				last	= new KBEditListViewItem
					  (	&m_fixedCols,
						last,
						QString("%1").arg(colno ),
						fldSpec->m_name,
						QString("%1").arg(offset),
						QString("%1").arg(fldSpec->m_length)
					  )	;

				colno	+= 1 ;
				offset	+= fldSpec->m_length ;
			}
		)
	}

	new KBEditListViewItem (&m_fixedCols, last) ;
}

/*  KBFileWidget							*/
/*  clickSample	: User clicks sample button				*/
/*  (returns)	: void		:					*/

void	KBFileWidget::clickSample ()
{
}
