/***************************************************************************
    file	         : kb_xmlwidget.cpp
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#include	<stdlib.h>

#include	<qapp.h>
#include	<qdom.h>


#include	"kb_classes.h"
#include	"kb_type.h"
#include	"kb_value.h"
#include	"kb_location.h"

#include	"kb_dbinfo.h"
#include	"kb_dblink.h"
#include	"kb_serverinfo.h"
#include	"kb_fieldchooser.h"

#ifndef 	_WIN32
#include	"kb_xmlwidget.moc"
#else
#include 	"kb_xmlwidget.h"
#endif

#include	"tk_icons.h"
#include	"tk_filedialog.h"



/*  KBXMLWidget								*/
/*  KBXMLWidget	: Constructor for file copier widget			*/
/*  parent	: QWidget *	: Parent widget				*/
/*  part	: QObject *	: Parent copier part			*/
/*  srce	: bool		: File is source			*/
/*  location	: KBLocation &	: Database location			*/
/*  (returns)	: KBTableWidget	:					*/

KBXMLWidget::KBXMLWidget
	(	QWidget		*parent,
		QObject		*part,
		bool		srce,
		KBLocation	&location
	)
	:
	QWidget		(parent),
	KBCopyXML	(srce, location),
	m_part		(part),
	m_srce		(srce),
	m_location	(location),

#if	__KB_EMBEDDED
	m_wTags		(this),
	m_wFields	(this),
	m_wFile		(this),
#else
	m_gbTags	(2, Qt::Horizontal, TR("XML Tags"),   this),
	m_gbFields	(1, Qt::Horizontal, TR("Fields"),     this),
	m_gbFile	(3, Qt::Horizontal, TR("File/Error"), this),

	m_wTags		(&m_gbTags),
	m_wFields	(&m_gbFields),
	m_wFile		(&m_gbFile),
#endif
	m_lMainTag	(&m_wTags),
	m_eMainTag	(&m_wTags),
	m_lRowTag	(&m_wTags),
	m_eRowTag	(&m_wTags),

	m_fieldList	(true, &m_wFields),
	m_bTable	(&m_wFields),
	m_bSample	(&m_wFields),

	m_eFile		(&m_wFile),
	m_bBrowse	(&m_wFile),
	m_cbErrOpt	(&m_wFile)

{
	m_layMain	 = new QVBoxLayout (this) ;

#if	__KB_EMBEDDED
	m_layMain->addWidget (&m_wTags	 ) ;
	m_layMain->addWidget (&m_wFields ) ;
	m_layMain->addWidget (&m_wFile	 ) ;
#else
	m_layMain->addWidget (&m_gbTags	 ) ;
	m_layMain->addWidget (&m_gbFields) ;
	m_layMain->addWidget (&m_gbFile	 ) ;
#endif
	m_layTags  = new QGridLayout    (&m_wTags) ;
	m_layTags ->addWidget (&m_lMainTag,  0, 0) ;
	m_layTags ->addWidget (&m_eMainTag,  0, 1) ;
	m_layTags ->addWidget (&m_lRowTag,   1, 0) ;
	m_layTags ->addWidget (&m_eRowTag,   1, 1) ;

	m_layFields = new QGridLayout (&m_wFields) ;
	m_layFields->addMultiCellWidget (&m_fieldList, 0, 0, 0, 1) ;
	m_layFields->addWidget (&m_bTable,   1, 0) ;
	m_layFields->addWidget (&m_bSample,  1, 1) ;

	m_layFile  = new QHBoxLayout    (&m_wFile) ;
	m_layFile ->addWidget (&m_eFile   ) ;
	m_layFile ->addWidget (&m_bBrowse ) ;
	m_layFile ->addWidget (&m_cbErrOpt) ;

	_KBDialog::setupLayout  (m_layMain,   -1, -1) ;
	_KBDialog::setupLayout  (m_layTags,   -1, -1) ;
	_KBDialog::setupLayout  (m_layFields, -1, -1) ;
	_KBDialog::setupLayout  (m_layFile,   -1, -1) ;

	m_lMainTag  .setText    (TR("Main document tag")) ;
	m_lRowTag   .setText    (TR("Row element tag"  )) ;

	m_cbErrOpt  .insertItem (m_srce ? TR("Ignore excess") : TR("Pad with nulls")) ;
	m_cbErrOpt  .insertItem (TR("Skip line"	 )) ;
	m_cbErrOpt  .insertItem (TR("Abort copy"	 )) ;

	connect (&m_eMainTag,     SIGNAL(textChanged   (const QString &)), part, SLOT(setChanged())) ;
	connect (&m_eRowTag,      SIGNAL(textChanged   (const QString &)), part, SLOT(setChanged())) ;


	m_fieldList.addColumn (TR("Index" )) ;
#if	__KB_EMBEDDED
	m_fieldList.addColumn (TR("Tag/Attribute"), 150) ;
#else
	m_fieldList.addColumn (TR("Tag/Attribute"), 220) ;
#endif

	m_bBrowse  .setPixmap (getSmallIcon("browse")) ;
	m_bTable   .setText   (TR("Set from table" )) ;
	m_bSample  .setText   (TR("Set from sample")) ;

	new KBEditListViewItem (&m_fieldList, "0") ;

	connect	(&m_fieldList, SIGNAL(changed (uint,uint)), part, SLOT(setChanged ())) ;
	connect	(&m_fieldList, SIGNAL(inserted(uint)),	    part, SLOT(setChanged ())) ;
	connect	(&m_fieldList, SIGNAL(deleted (uint)), 	    part, SLOT(setChanged ())) ;
	connect	(this, 	       SIGNAL(changed ()), 	    part, SLOT(setChanged ())) ;

	connect	(&m_bBrowse,   SIGNAL(clicked()), this, SLOT(clickBrowse())) ;
	connect	(&m_bTable,    SIGNAL(clicked()), this, SLOT(clickTable ())) ;
	connect	(&m_bSample,   SIGNAL(clicked()), this, SLOT(clickSample())) ;

	connect	(&m_eFile,     SIGNAL(textChanged(const QString &)), part, SLOT(setChanged())) ;

	if (!m_srce)
	{
		m_fieldList.addColumn (TR("AsAttr")) ;
		m_fieldList.setEditType (2, KBEditListView::EdCheckBox) ;
	}
}

/*  KBXMLWidget							*/
/*  saveall	: Save all settings to copy object			*/
/*  (returns)	: void		:					*/

void	KBXMLWidget::saveall ()
{
	reset	  () ;

	setErrOpt (m_cbErrOpt    .currentItem()) ;
	setMainTag(m_eMainTag    .text	   ()) ;
	setRowTag (m_eRowTag     .text	   ()) ;
	setFile	  (m_eFile       .text	   ()) ;

	for (QListViewItem *item  = m_fieldList.firstChild() ;
			    item != 0 ;
			    item  = item->nextSibling())
		if (!item->text(1).isEmpty())
			addField (item->text(1), item->text(2) == "Yes") ;
}

/*  KBXMLWidget								*/
/*  error	: KBError &	 : Error return				*/
/*  (returns)	: bool		 : Success				*/

bool	KBXMLWidget::valid
	(	KBError		&error
	)
{
	saveall	() ;
	return	KBCopyXML::valid (error) ;
}

/*  KBXMLWidget								*/
/*  set		: Set copier from definition				*/
/*  copy	: QDomElement & : Definition parent			*/
/*  error	: KBError &	: Error return				*/
/*  (returns)	: bool		: Success				*/

bool	KBXMLWidget::set
	(	QDomElement	&copy,
		KBError		&error
	)
{
	if (!KBCopyXML::set (copy, error)) return false ;

	m_eMainTag.setText	 (getMainTag()) ;
	m_eRowTag .setText 	 (getRowTag ()) ;
	m_cbErrOpt.setCurrentItem(getErrOpt()) ;

	uint		idx	;
	QString		name	;
	bool		asattr	;
	QListViewItem	*last	= 0 ;

	m_fieldList.clear () ;

	for (idx = 0 ; getField (idx, name, asattr) ; idx += 1)
		last	= new KBEditListViewItem
			  (	&m_fieldList,
				last,
				QString("%1").arg(idx),
				name,
				asattr ? "Yes" : "No"
			  )	;

	new	KBEditListViewItem (&m_fieldList, last, QString("%1").arg(idx)) ;

	m_eFile.setText (getFile ()) ;

	return	true	;
}

/*  KBXMLWidget								*/
/*  def		: Get file copy definition				*/
/*  copy	: QDomElement &	: Element to which to attach		*/
/*  (returns)	: void		:					*/

void	KBXMLWidget::def
	(	QDomElement	&copy
	)
{
	saveall	() ;
	return	KBCopyXML::def (copy) ;
}

/*  KBXMLWidget							*/
/*  clickBrowse	: User clicks browse button				*/
/*  (returns)	: void		:					*/

void	KBXMLWidget::clickBrowse ()
{
	QString	name	;

	if (m_srce)
		name	= KBFileDialog::getOpenFileName
			  (	QString::null,
			  	"*.txt|Text files\n*.xml|XML files\n*.*|All files",
			  	qApp->activeWindow(),
			  	"Source File"
			  )	;
	else	name	= KBFileDialog::getSaveFileName
			  (	QString::null,
			  	"*.txt|Text files\n*.xml|XML files\n*.*|All files",
			  	qApp->activeWindow(),
			  	"Destination File"
			  )	;

	if (!name.isEmpty())
	{	m_eFile.setText (name) ;
		emit changed  ()     ;
	}
}

/*  KBXMLWidget								*/
/*  clickTable	: User clicks table button				*/
/*  (returns)	: void		:					*/

void	KBXMLWidget::clickTable ()
{
	KBFieldChooserDlg fDlg (m_location, true) ;

	if (!fDlg.exec()) return ;

	QString		svrName	= fDlg.getServer () ;
	QString		tabName	= fDlg.getObject () ;
	QStringList	fields	= fDlg.getFields () ;

	KBTableSpec 	tabSpec (tabName) ;
	KBDBLink    	dbLink  ;

	if (!dbLink.connect (m_location, svrName))
	{	dbLink.lastError().DISPLAY() ;
		return	;
	}

	if (!dbLink.listFields (tabSpec))
	{	dbLink.lastError().DISPLAY() ;
		return	;
	}

	QListViewItem	*last	= 0 ;

	m_fieldList.clear () ;

	for (uint idx = 0 ; idx < fields.count() ; idx += 1)
	{
		QString	field	= *fields.at(idx) ;

		last	= new KBEditListViewItem
			  (	&m_fieldList,
				last,
				QString("%1").arg(idx),
				field,
				"No"
			  )	;
	}

	new KBEditListViewItem (&m_fieldList, last) ;
}

/*  KBXMLWidget								*/
/*  clickSample	: User clicks sample button				*/
/*  (returns)	: void		:					*/

void	KBXMLWidget::clickSample ()
{
}
