/***************************************************************************
    file	         : kb_xmlwidget.h
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#ifndef	__KB_XMLWIDGET_H
#define	__KB_XMLWIDGET_H

#include	<qlayout.h>
#include	<qgroupbox.h>
#include	<qlabel.h>
#include	<qcombobox.h>
#include	<qlineedit.h>
#include	<qlistbox.h>
#include	<qpushbutton.h>
#include	<qlabel.h>

#include	"kb_editlistview.h"
#include	"kb_copybase.h"
#include	"kb_copyxml.h"


/*  KBXMLWidget								*/
/*  -----------								*/
/*  This is the copied widget which provides the user GUI interface to	*/
/*  the XML copier object.						*/

class	KBXMLWidget : public QWidget, public KBCopyXML
{
	Q_OBJECT

	QObject		*m_part		;

	bool		m_srce		;
	KBLocation	m_location	;

	QVBoxLayout	*m_layMain	;

#if	! __KB_EMBEDDED
	QGroupBox	m_gbTags	;
	QGroupBox	m_gbFields	;
	QGroupBox	m_gbFile	;
#endif
	QWidget		m_wTags		;
	QWidget		m_wFields	;
	QWidget		m_wFile		;

	QLabel		m_lMainTag	;
	QLineEdit	m_eMainTag	;
	QLabel		m_lRowTag	;
	QLineEdit	m_eRowTag	;
	QGridLayout	*m_layTags	;

	KBEditListView	m_fieldList	;
	QPushButton	m_bTable	;
	QPushButton	m_bSample	;
	QGridLayout	*m_layFields	;

	QLineEdit	m_eFile		;
	QPushButton	m_bBrowse	;
	QComboBox	m_cbErrOpt	;
	QHBoxLayout	*m_layFile	;


	void		saveall		() ;

signals	:

	void		changed		() ;

protected slots	:

	void		clickBrowse	() ;
	void		clickTable	() ;
	void		clickSample	() ;

public	:

	KBXMLWidget	(QWidget *parent, QObject *, bool, KBLocation &) ;

	bool		valid		(KBError     &) ;
	void		def		(QDomElement &) ;
	bool		set		(QDomElement &, KBError &) ;
}	;
#endif	// __KB_XMLWIDGET_H
