/***************************************************************************
    file	         : kb_wizform.h
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#ifndef		__KB_WIZFORM_H
#define		__KB_WIZFORM_H

#include	<qpushbutton.h>

#include	"kb_classes.h"
#include	"kb_dialog.h"
#include	"kb_wizard.h"
#include	"kb_wizsource.h"
#include	"kb_wizfields.h"


/*  KBWizardFormFrame							*/
/*  -----------------							*/
/*  This class exists simply so that we can provide a size hint. Should	*/
/*  really be done by the KBDispScroller class ...			*/

class	KBWizardFormFrame : public QWidget
{
	QSize		m_size	;

public	:

	KBWizardFormFrame	(QWidget *) ;

	void		setWidget	(QWidget *, const QSize &) ;
	virtual	QSize	sizeHint	() const	;
}	;


/*  KBWizardFormPreview							*/
/*  -------------------							*/
/*  Class used to preview a wizard defined form, gives the user a	*/
/*  chance to have a look and make changes before saving the form.	*/

class	KBWizardFormPreview : public _KBDialog
{
	KBWizardFormFrame	m_frame		;
	QPushButton		m_bOK		;
	KBForm			*m_form		;
	QWidget			*m_top		;
	QWidget			*m_display	;

	virtual	bool	eventFilter	(QObject *, QEvent *) ;

protected :

	virtual	bool	focusNextPrevChild (bool) ;

public	:

	KBWizardFormPreview	(const QString &, bool &ok) ;
	~KBWizardFormPreview	() ;
}	;


/*  KBWizardForm							*/
/*  ------------							*/
/*  Wizard class for creation of forms.					*/

class	KBWizardForm : public KBWizard
{
	KBLocation	&m_location	;

public	:

	KBWizardForm	(KBLocation &, const QString &) ;

	int		exec	() ;
	QString		create	(QString &, KB::ShowAs &, bool = false) ;

	inline	KBWizardCtrlDataSource::Type sourceType	()
	{
		return	(KBWizardCtrlDataSource::Type)ctrlAttribute	("source", "object", "type"  ).toInt	   () ;
	}

	inline	QString		sourceName	() { return ctrlValue		("source", "object"  ) ; }
	inline	QStringList	fields		() { return ctrlAttribute 	("fields", "fields", "fields").toStringList() ; }
	inline	int		layout		() { return ctrlAttribute 	("layout", "layout", "index" ).toInt	   () ; }
	inline	bool		stretch		() { return ctrlValue		("layout", "stretch"	     ).toInt	   () ; }
	inline	bool		move		() { return ctrlValue		("navi",   "move"	     ).toInt	   () ; }
	inline	bool		update		() { return ctrlValue		("navi",   "update"	     ).toInt	   () ; }
	inline	int		scroll		() { return ctrlAttribute	("navi",   "scroll", "index" ).toInt	   () ; }
	inline	int		mode		() { return ctrlAttribute	("final",  "mode",   "index" ).toInt	   () ; }
	inline	QString		caption		() { return ctrlValue		("names",  "caption" ) ; }
	inline	QString		name		() { return ctrlValue		("names",  "name"    ) ; }

	inline	void	fieldList
		(	QList<KBFieldSpec>	&fieldList
		)
	{
		((KBWizardCtrlFields *)findCtrl("fields", "fields"))->fields (fieldList) ;
	}
}	;


#endif		// __KB_WIZFORM_H
