/***************************************************************************
    file	         : kb_querylist.cpp
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#include 	<qcursor.h>
#include 	<qpopupmenu.h>

#include	"kb_classes.h"
#include	"kb_location.h"
#include	"kb_dbinfo.h"
#include	"kb_listitem.h"
#include	"kb_viewer.h"

#ifndef 	_WIN32
#include	"kb_querylist.moc"
#else
#include	"kb_querylist.h"
#endif

#include	"kb_queryviewer.h"


/*  KBQueryList								*/
/*  KBQueryList	: Constructor for query list widget			*/
/*  parent	: QWidget *	: Parent widget				*/
/*  dbInfo	: KBDBInfo *	: Database information object		*/
/*  (returns)	: KBQueryList	:					*/

KBQueryList::KBQueryList
	(	QWidget		*parent,
		KBDBInfo	*dbInfo
	)
	:
	KBFileList
	(	parent,
		dbInfo,
		"Create new query",
		"query",
		"query",
		"Query name"
	)
{
}

/*  KBQueryList								*/
/*  ~KBQueryList: Destructor for query list widget			*/
/*  (returns)	:		:					*/

KBQueryList::~KBQueryList ()
{
}

/*  KBQueryList								*/
/*  showServerMenu : Show popup menu for server entries			*/
/*  (returns)	   : void	:					*/

void	KBQueryList::showServerMenu ()
{
	QPopupMenu pop ;
	pop.insertItem (TR("Cancel")) ;
	pop.insertSeparator () ;
	pop.insertItem (TR("&Reload query list"),  this, SLOT(reloadServer())) ;
#if	! __KB_RUNTIME
	pop.insertItem (TR("&Copy to server ..."), this, SLOT(copyToServer())) ;
#endif
	pop.exec       (QCursor::pos()) ;
	return	;
}

/*  KBQueryList								*/
/*  showObjectMenu : Show popup menu for server entries			*/
/*  (returns)	   : void	:					*/

void	KBQueryList::showObjectMenu ()
{
	QPopupMenu pop ;
	pop.insertItem (TR("Cancel")) ;
	pop.insertItem (TR("&Data view"),     this, SLOT(showAsData  ())) ;
#if	! __KB_RUNTIME
	pop.insertItem (TR("D&esign view"),   this, SLOT(showAsDesign())) ;
	pop.insertItem (TR("&Rename query"),  this, SLOT(renameQuery ())) ;	
	pop.insertItem (TR("De&lete query"),  this, SLOT(deleteQuery ())) ;
	pop.insertItem (TR("&Save to file"),  this, SLOT(saveToFile  ())) ;
#endif
	pop.exec       (QCursor::pos()) ;
}



/*  KBQueryList								*/
/*  renameQuery	: Rename a query						*/
/*  (returns)	: void		:					*/

void	KBQueryList::renameQuery ()
{
	rename	(m_curItem) ;
}

/*  KBQueryList								*/
/*  deleteQuery	: Delete a query						*/
/*  (returns)	: void		:					*/

void	KBQueryList::deleteQuery ()
{
	delobj	(m_curItem) ;
}
