/***************************************************************************
    file	         : kb_lookup.h
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#ifndef	__KB_LOOKUP_H

#include	<qwidget.h>
#include	<qlayout.h>
#include	<qlabel.h>
#include	<qcombobox.h>

#include	"kb_classes.h"
#include	"kb_helper.h"
#include	"kb_location.h"
#include	"kb_dblink.h"


/*  KBLookupHelper							*/
/*  --------------							*/
/*  This class implements a helper for the link lookup setting, giving	*/
/*  the user a choice of table and field to link against, and an	*/
/*  expression to display.						*/

class	KBLookupHelper : public QWidget, public KBHelperBase
{
	Q_OBJECT

	QGridLayout		vLayout		;
	QLabel			lTable		;
	QLabel			lField		;
	QLabel			lShow		;
	QComboBox		cTable		;
	QComboBox		cField		;
	QComboBox		eShow		;

	const KBLocation	&location	;
	KBDBLink		dbLink		;

	void		setFields (QString)	;
	void		setExpr   (QString)	;

private slots :

	void		pickTable	(int)	;
	void		pickField	(int)	;

public	:

	KBLookupHelper (QWidget *, const KBLocation &) ;
	virtual ~KBLookupHelper () ;

	virtual	void	setValue (const QString &) ;
	virtual QString	getValue () ;
}	;

#define	__KB_LOOKUP_H
#endif	// __KB_LOOKUP_H
