import	Rekall
import	RekallMain
import	string

#  Form load handler
#  We see if there is a complete set of column orderings, in which case
#  we use those to rearrange the grid.
#
def onFormLoad (form) :

    global	orderHash

    # The table designer adds an attribute "ident" to the table data
    # form which contains a string or the form "Server/Table". This
    # This is used in combination with the grid item names (which are
    # the column names) to provide a column-unique hash key.
    #
    tableIdent	= form  .getAttr   ("ident")

    # Also use this to get the server and table names and retrieve the
    # current column widths. Store these in a hash table.
    #
    sAndT	= string.split	   (tableIdent, "/")
    dbLink	= form  .openServer(sAndT[0])

    # Locate the grid control, get a list of all items, and allocate
    # vectprs in which to store the order and width values.
    #
    gridCtrl	= form.getNamedCtrl("$$grid$$")
    initItems	= gridCtrl.getItems()
    sortItems	= [ 0 ] * len(initItems)
    widthItems	= [ 0 ] * len(initItems)

    # Scan through all the items in the data grid. For each, look to see
    # if there is an entry in the order hash table for the item and pick
    # up the width from the width hash table.
    #
    for index in range (len(initItems)) :

	gridItem  = initItems[index]
	itemName  = gridItem.getAttr("name")
	entryName = tableIdent + "/" + itemName

	# If the item has no name then it is the row marker, which is
	# left in the same place ....
	#
	if itemName == "" :
	    sortItems[index] = gridItem
	    continue

	# If no order hash entry was found then the order is just the
	# index, else not the current setting from the hash table.
	# Similarly for the width; zero is interpreted as leaving the
	# width unchanged.
	#
	if orderHash.has_key (entryName) :
	    order = orderHash[entryName]
	else :
	    order = index

        width = dbLink.getColumnWidth (sAndT[1], itemName)

	# Check that the order value is in range. It may not be if the
	# user has deleted a column since the data was last displayed.
	# If not in range then leave items in place.
	#
	if (order < 0) or (order >= len(initItems)) :
	    return

	# Order found and is plausible, so store the item reference at
	# the corresponding position in the ordered items list. Also
	# note the column width.
	#
	sortItems [order] = gridItem
	widthItems[order] = width

    # We need to make sure that all items have been accounted for, ie.,
    # that all entries in the ordered items list are set. If any are
    # missing then once more allow the default; this occurs when a new
    # column is added. Also convert null widths to zero.
    #
    for index in range (len(initItems)) :
	if sortItems [index] == 0    : return
	if widthItems[index] == None : widthItems[index] = 0

    # All present and correct ... reorder the grid and set the column
    # width of each.
    #
    gridCtrl.setOrder (sortItems)

    for index in range (len(initItems)) :
	gridCtrl.setColumnWidth (sortItems[index], int(widthItems[index]))



#  Form unload handler
#  This routine exits when table data form unloads, in order to save the
#  column ordering.
#
def onFormUnload (form) :

    global	orderHash

    tableIdent	= form  .getAttr   ("ident")
    sAndT	= string.split	   (tableIdent, "/")
    dbLink	= form  .openServer(sAndT[0])

    if dbLink == None :
        return

    gridCtrl	= form.getNamedCtrl("$$grid$$")
    currItems	= gridCtrl.getItems()

    # Scan over each item, noting the current order and width, with the
    # exception of any unnamed item, which will be the row marker.
    #
    for index in range (len(currItems)) :

	gridItem	= currItems[index]
	itemName	= gridItem.getAttr("name")
	entryName	= tableIdent + "/" + itemName

	if itemName != "" :
	    orderHash[entryName] = index

	dbLink.setColumnWidth(sAndT[1], itemName, int(gridItem.width()))



orderHash	= {}
