/***************************************************************************
    file	         : kb_itemproxy.cpp
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#include	<kjs/global.h>
#include	<kjs/interpreter.h>
#include	<kjs/lookup.h>
#include	<kjs/object.h>
#include	<kjs/operations.h>
#include	<kjs/types.h>
#include	<kjs/ustring.h>
#include	<kjs/value.h>


#include	"kb_classes.h"
#include	"kb_item.h"

#include	"kb_idbase.h"
#include	"kb_objectproxy.h"
#include	"kb_itemproxy.h"
#include	"kb_kjsregister.h"



extern	QString kjsStringArg	(KJS::ExecState *, const KJS::List &, int) ;


/*  KBItemProxy								*/
/*  KBItemProxy	: Constructor for rekall item proxy			*/
/*  interp	: KJS::Interpreter *	: Intepreter object		*/
/*  object	: KBItem *		: Rekall object			*/
/*  (returns)	: KBItemProxy		:				*/

KBItemProxy::KBItemProxy
	(	KJS::Interpreter	*interp,
		KBItem			*item
	)
	:
	KBObjectProxy	(interp, item)
{
}

/*  KBItemProxy								*/
/* ~KBItemProxy	: Destructor for rekall object proxy			*/
/*  (returns)	:		:					*/

KBItemProxy::~KBItemProxy ()
{
}

/*  KBItemProxy								*/
/*  addBindings	: Add proxy bindings to specified object		*/
/*  exec	: KJS::ExecState *	: Execution state		*/
/*  object	: KJS::Object &		: Object to which to add	*/
/*  (returns)	: void			:				*/

void	KBItemProxy::addBindings
	(	KJS::ExecState	*exec,
		KJS::Object	&object
	)
{
	static	struct	MethodSpec
	{	cchar		*name	;
		uint		id	;
	}
		methods	[] =
		{
			{	"setValue",	MethodImp::id_setValue		},
			{	"getValue",	MethodImp::id_getValue		},
			{	"setEnabled",	MethodImp::id_setEnabled	},
			{	"setVisible",	MethodImp::id_setVisible	},
			{	"isEnabled",	MethodImp::id_isEnabled		},
			{	"isVisible",	MethodImp::id_isVisible		},
			{	0,		0				}
		}	;

	for (MethodSpec *ms = &methods[0] ; ms->name != 0 ; ms += 1)
		object.put
		(	m_interp->globalExec(),
			ms->name,
			KJS::Object(new MethodImp(ms->id, this))
		)	;

	KBObjectProxy::addBindings (exec, object) ;
}

/*  KBItemProxy								*/
/*  get		: Get property value					*/
/*  exec	: KJS::ExecState *	: Execution state		*/
/*  property	: constKJS::UString &	: Property name			*/
/*  (returns)	: KJS::Value		: Result			*/

KJS::Value
	KBItemProxy::get
	(	KJS::ExecState		*exec,
		const KJS::UString	&property
	)
	const
{
	QString	p = property.qstring() ;

	fprintf
	(	stderr,
		"KBItemProxy::get: [%s][%s]\n",
		(cchar *)m_object->getName(),
		(cchar *)p
	)	;

	return	KJS::ObjectImp::get (exec, property) ;
}

/*  KBItemProxy								*/
/*  put		: Set property value					*/
/*  exec	: KJS::ExecState *	: Execution state		*/
/*  property	: const KJS::UString &	: Property name			*/
/*  value	: const KJS::Value &	: Value				*/
/*  attr	: int			:				*/
/*  (returns)	: void			:				*/

void	KBItemProxy::put
	(	KJS::ExecState		*exec,
		const KJS::UString	&property,
		const KJS::Value	&value,
		int			attr
	)
{
	QString	p = property.qstring() ;


	KJS::ObjectImp::put (exec, property, value, attr) ;
}


/*  ------------------------------------------------------------------  */

/*  KBItemProxy								*/
/*  MethodImp	: 							*/
/*  MethodImp	: Object implementation					*/
/*  id		: uint		  : Method identifier			*/
/*  object	: KBItemProxy * : Associated proxy			*/
/*  (return)	: MethodImp	  :					*/

KBItemProxy::MethodImp::MethodImp
	(	uint			id,
		const KBItemProxy	*item
	)
	:
	KBObjectProxy::MethodImp(id, item),
	m_item			(item)
{
}


/*  MethodImp								*/
/*  call	: Invoke a method					*/
/*  exec	: KJS::ExecState *	: Execution state		*/
/*  obj		: KJS::Object &		: Apparently "self"		*/
/*  args	: const KJS::List	: Argument list			*/
/*  (returns)	: KJS::Value		: Result			*/

KJS::Value
	KBItemProxy::MethodImp::call
	(	KJS::ExecState		*exec,
		KJS::Object		&object,
		const KJS::List		&args
	)
{
	uint	row	= args.at(0).toInteger(exec) ;
	KBItem	*item	= m_item->m_object->isItem() ;

	fprintf
	(	stderr,
		"KBItemProxy::MethodImp::call: [%s] for [%d]\n",
		(cchar *)item->getName(),
		m_id
	)	;

	switch (m_id)
	{
		case id_setValue	:
			item->setValue (row, kjsStringArg (exec, args, 1)) ;
			return	KJS::Null() ;

		case id_getValue	:
			return	KJS::String(item->getValue(row).getRawText()) ;

		case id_setEnabled	:
			item->setEnabled(row, args.at(1).toBoolean(exec)) ;
			return	KJS::Null() ;

		case id_setVisible	:
			item->setVisible(row, args.at(1).toBoolean(exec)) ;
			return	KJS::Null() ;

		case id_isEnabled	:
			return	KJS::Number(item->isEnabled(row)) ;

		case id_isVisible	:
			return	KJS::Number(item->isVisible(row)) ;

		default	:
			break	;
	}

	return	KBObjectProxy::MethodImp::call (exec, object, args) ;
}

KBObjectProxy
	*makeItemProxy
	(	KJS::Interpreter	*interp,
		KBNode			*node
	)
{
	return	new KBItemProxy (interp, (KBItem *)node) ;
}

static	KBKJSRegister	_itemReg ("KBItem", makeItemProxy) ;
