/***************************************************************************
    file	         : kb_itemproxy.h
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#ifndef	__KB_ITEMPROXY_H
#define	__KB_ITEMPROXY_H


/*  KBItemProxy								*/
/*  -----------								*/
/*  Proxy class for Rekall items ....					*/

class	KBItemProxy : public KBObjectProxy
{
public	:

	KBItemProxy	(KJS::Interpreter *, KBItem *) ;
	~KBItemProxy	() ;


	virtual	void		addBindings
				(	KJS::ExecState		*,
					KJS::Object		&
				)	;

	virtual	KJS::Value	get
				(	KJS::ExecState		*,
					const KJS::UString	&
				)
				const	;

	virtual	void		put
				(	KJS::ExecState		*,
					const KJS::UString	&,
					const KJS::Value	&,
					int			= KJS::None
				)	;

protected :

	class MethodImp : public KBObjectProxy::MethodImp
	{
	protected :

		const KBItemProxy	*m_item		;

	public	:


		MethodImp	(uint, const KBItemProxy *) ;
		~MethodImp()	{}

		virtual	KJS::Value call
			(	KJS::ExecState	*,
				KJS::Object	&,
				const KJS::List &
			)	;

		static	const uint	id_setValue	= IDB_ITEM + 1	;
		static	const uint	id_getValue	= IDB_ITEM + 2	;
		static	const uint	id_setEnabled	= IDB_ITEM + 3	;
		static	const uint	id_setVisible	= IDB_ITEM + 4	;
		static	const uint	id_isEnabled	= IDB_ITEM + 5	;
		static	const uint	id_isVisible	= IDB_ITEM + 6	;

	}	;

	friend	class	MethodImp ;
}	;

#endif	// __KB_ITEMPROXY_H
