/***************************************************************************
    file	         : kb_kjdebug.cpp
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#include	<kjs/global.h>
#include	<kjs/interpreter.h>
#include	<kjs/lookup.h>
#include	<kjs/object.h>
#include	<kjs/operations.h>
#include	<kjs/types.h>
#include	<kjs/ustring.h>
#include	<kjs/value.h>

#include	"kb_kjdebug.h"



int		 KBKJSDebugger::m_lastSourceID	;
int		 KBKJSDebugger::m_lastLine	;
KBKJSDebugger	*KBKJSDebugger::m_self		;


KBKJSDebugger::KBKJSDebugger ()
{
}

bool	KBKJSDebugger::sourceParsed
	(	KJS::ExecState		*exec,
		int			sourceId,
		const KJS::UString	&source,
		int			errorLine
	)
{
	fprintf
	(	stderr,
		"KBKJSDebugger::sourceParsed: id=%d eln=%d\n",
		sourceId,
		errorLine
	)	;

	m_lastSourceID	= sourceId	;
	m_lastLine	= errorLine	;

	return	true	;
}


bool	KBKJSDebugger::atStatement
	(	KJS::ExecState	*exec,
		int		sourceId,
		int		firstLine,
		int		lastLine
	)
{
	fprintf
	(	stderr,
		"KBKJSDebugger::atStatement: id=%d lno=%d\n",
		sourceId,
		firstLine
	)	;

	m_lastSourceID	= sourceId	;
	m_lastLine	= firstLine	;

	return	true	;
}

bool	KBKJSDebugger::callEvent
	(	KJS::ExecState	*exec,
		int		sourceId,
		int		lineno,
		KJS::Object	&function,
		const KJS::List	&args
	)
{
	fprintf
	(	stderr,
		"KBKJSDebugger::callEvent: id=%d lno=%d\n",
		sourceId,
		lineno
		
	)	;

	m_lastSourceID	= sourceId	;
	m_lastLine	= lineno	;

	return	true	;
}

bool	KBKJSDebugger::returnEvent
	(	KJS::ExecState	*exec,
		int		sourceId,
		int		lineno,
		KJS::Object	&function
	)
{
	fprintf
	(	stderr,
		"KBKJSDebugger::returnEvent: id=%d lno=%d\n",
		sourceId,
		lineno
	)	;

//	m_lastSourceID	= sourceId	;
//	m_lastLine	= lineno	;

	return	true	;
}

bool	KBKJSDebugger::exception
	(	KJS::ExecState	*exec,
		int		sourceId,
		int		lineno,
		KJS::Object 	&exceptionObj
	)
{
	fprintf
	(	stderr,
		"KBKJSDebugger::exception: id=%d lno=%d\n",
		sourceId,
		lineno
	)	;

	m_lastSourceID	= sourceId	;
	m_lastLine	= lineno	;

	return	true	;
}



KBKJSDebugger
	*KBKJSDebugger::self ()
{
	if (m_self == 0) m_self = new KBKJSDebugger() ;
	return	m_self ;
}
