/***************************************************************************
    file	         : kb_objectproxy.h
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#ifndef	__KB_OBJECTPROXY_H
#define	__KB_OBJECTPROXY_H

/*  KBObjectProxy							*/
/*  -------------							*/
/*  Proxy class for Rekall objects. All other proxy classes are derived	*/
/*  from this.								*/

class	KBObjectProxy : public KJS::ObjectImp
{
protected :

	KJS::Interpreter	*m_interp	;
	KBObject		*m_object 	;

public	:

	KBObjectProxy	(KJS::Interpreter *, KBObject *) ;
	~KBObjectProxy	() ;


	virtual	void		addBindings
				(	KJS::ExecState		*,
					KJS::Object		&
				)	;

	virtual	KJS::Value	get
				(	KJS::ExecState		*,
					const KJS::UString	&
				)
				const	;

	virtual	void		put
				(	KJS::ExecState		*,
					const KJS::UString	&,
					const KJS::Value	&,
					int			= KJS::None
				)	;

protected :

	class MethodImp : public KJS::ObjectImp
	{
	protected :

		uint			m_id		;
		const KBObjectProxy	*m_object	;

	public	:


		MethodImp	(uint, const KBObjectProxy *) ;
		~MethodImp()	{}

		virtual	bool	implementsCall () const
		{
			return	true	;
		}

		virtual	KJS::Value call
			(	KJS::ExecState	*,
				KJS::Object	&,
				const KJS::List &
			)	;

		static	const uint	id_getAttr	= IDB_OBJECT + 1 ;
		static	const uint	id_getConfig	= IDB_OBJECT + 2 ;
		static	const uint	id_setAttr	= IDB_OBJECT + 3 ;
		static	const uint	id_resize	= IDB_OBJECT + 4 ;
		static	const uint	id_getNamedCtrl	= IDB_OBJECT + 5 ;

	}	;

	friend	class	MethodImp ;
}	;

#endif	// __KB_OBJECTPROXY_H
