/***************************************************************************
    file	         : kb_rekallmain.cpp
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#include	<stdio.h>

#include	<kjs/global.h>
#include	<kjs/interpreter.h>
#include	<kjs/lookup.h>
#include	<kjs/object.h>
#include	<kjs/operations.h>
#include	<kjs/types.h>
#include	<kjs/ustring.h>
#include	<kjs/value.h>

#include	"kb_classes.h"
#include	"kb_prompt.h"
#include	"kb_rekallmain.h"
#include	"kb_rekallmain.lut"

#include	"kb_port_gui.h"


using	namespace	KJS	;


extern	QString kjsStringArg	(ExecState *, const List &, int) ;


const	ClassInfo	RekallMainObjectImp::info =
			{
				"RekallMain",
				0,
				&rekallMainTable,
				0
			}	;

#if	0
@begin rekallMainTable 21
  actFirst	RekallMainObjectImp::actFirst		DontEnum|DontDelete|ReadOnly
  actPrevious	RekallMainObjectImp::actPrevious	DontEnum|DontDelete|ReadOnly
  actNext	RekallMainObjectImp::actNext		DontEnum|DontDelete|ReadOnly
  actLast	RekallMainObjectImp::actLast		DontEnum|DontDelete|ReadOnly
  actAdd	RekallMainObjectImp::actAdd		DontEnum|DontDelete|ReadOnly
  actSave	RekallMainObjectImp::actSave		DontEnum|DontDelete|ReadOnly
  actDelete	RekallMainObjectImp::actDelete		DontEnum|DontDelete|ReadOnly
  actQuery	RekallMainObjectImp::actQuery		DontEnum|DontDelete|ReadOnly
  actExecute	RekallMainObjectImp::actExecute		DontEnum|DontDelete|ReadOnly
  actCancel	RekallMainObjectImp::actCancel		DontEnum|DontDelete|ReadOnly
  messageBox    RekallMainObjectImp::messageBox		DontEnum|Function 1
  choiceBox     RekallMainObjectImp::choiceBox		DontEnum|Function 2
@end
#endif


static	Value	choiceBox
	(	ExecState	*exec,
		const List	&args
	)
{
fprintf(stderr, "--->%d\n", (int)args.at(1).type()) ;
	if (!args.at(1).isA(KJS::ListType))
	{
		return	KJS::Number(-1) ;
	}

	QString		message	= kjsStringArg (exec, args, 0) ;
	KJS::List	options	= List::dynamicCast (args.at(1)) ;
	QStringList	cList	;
	QString		resVal	;

	for (int idx = 0 ; idx < options.size() ; idx += 1)
		cList.append (kjsStringArg(exec, options, idx)) ;

	KBChoiceDlg dDlg ("Database", message, cList, resVal) ;
	if (!dDlg.exec()) return KJS::Null() ;

	return	KJS::String(resVal) ;
}


/*  ------------------------------------------------------------------	*/

RekallMainObjectImp::RekallMainObjectImp
	(	ExecState		*,
		ObjectPrototypeImp	*objProto
	)
	:
	ObjectImp (Object(objProto))
{
	fprintf
	(	stderr,
		"RekallMainObjectImp::RekallMainObjectImp: called\n"
	)	;
}


Value	RekallMainObjectImp::get
	(	ExecState	*exec,
		const UString	&propertyName
	)
	const
{
	fprintf
	(	stderr,
		"RekallMainObjectImp::get\n"
	)	;

	return	lookupGet<RekallMainFunctionImp, RekallMainObjectImp, ObjectImp>
			 (	exec,
				propertyName,
				&rekallMainTable,
				this
			 )	;
}


Value	RekallMainObjectImp::getValueProperty
	(	ExecState	*,
		int		token
	)
	const
{
	switch (token)
	{
		case actFirst	:
			return	Number(KB::First   ) ;

		case actPrevious:
			return	Number(KB::Previous) ;

		case actNext	:
			return	Number(KB::Next    ) ;

		case actLast	:
			return	Number(KB::Last    ) ;

		case actAdd	:
			return	Number(KB::Add     ) ;

		case actSave	:
			return	Number(KB::Save    ) ;

		case actDelete	:
			return	Number(KB::Delete  ) ;

		case actQuery	:
			return	Number(KB::Query   ) ;

		case actExecute	:
			return	Number(KB::Execute ) ;

		case actCancel	:
			return	Number(KB::Cancel  ) ;

		default	:
			break	;
	}

	return	Number(-1)	;
}


RekallMainFunctionImp::RekallMainFunctionImp
	(	ExecState	*exec,
		int		id,
		int		length
	)
	:
	InternalFunctionImp
	(
		(FunctionPrototypeImp*)(exec->interpreter()->builtinFunctionPrototype().imp())
	),
	m_id	(id)
{
	fprintf
	(	stderr,
		"RekallMainFunctionImp::RekallMainFunctionImp: called\n"
	)	;

	Value	protect (this) ;
	put	(exec, "length", Number(length), DontDelete|ReadOnly|DontEnum) ;
}

bool	RekallMainFunctionImp::implementsCall () const
{
	return	true	;
}

Value	RekallMainFunctionImp::call
	(	ExecState	*exec,
		Object		&,
		const List	&args
	)
{
	fprintf
	(	stderr,
		"RekallMainFunctionImp::call: m_id=%d\n",
		m_id
	)	;

	switch (m_id)
	{
		case RekallMainObjectImp::messageBox :

			TKMessageBox::information
			(	0,
				kjsStringArg (exec, args, 0),
				kjsStringArg (exec, args, 1)
			)	;
			return	Number (0) ;

		case RekallMainObjectImp::choiceBox  :
			return	::choiceBox (exec, args) ;

		default	:
			break	;
	}

	return	Number(-1) ;

}

