/***************************************************************************
    file	         : kb_pysupport.cpp
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#include	<qstring.h>
#include	<qdict.h>

#include	"kb_python.h"


extern QString getPythonString (PyObject *) ;

void	pyDictToQtDict
	(	PyObject	*pyDict,
		QDict<QString>	&kbDict
	)
{
	PyObject	*key	;
	PyObject	*value	;
	int		pos	= 0 ;

	kbDict.setAutoDelete (true) ;

	if (pyDict != 0)
		while (PyDict_Next (pyDict, &pos, &key, &value))
			kbDict.insert
			(	getPythonString (key),
				new QString(getPythonString (value))
			)	;
}

PyObject
	*qtDictToPyDict
	(	QDict<QString>	&kbDict
	)
{
	PyObject		*pyDict	= PyDict_New() ;
	QString			*res	;
	QDictIterator<QString>	iter	(kbDict) ;

	while ((res = iter.current()) != 0)
	{
		QString	v = *res ;
		if (v.isNull()) v = "" ;

		PyDict_SetItemString
		(	pyDict,
			(char *)(const char *)iter.currentKey(),
			PyString_FromString((char *)(const char *)v)
		)	;
		iter	+= 1 ;
	}

	return	pyDict	;
}
