/***************************************************************************
    file	         : kb_basic.cpp
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#include	"kb_python.h"

#include	"kb_classes.h"
#include	"kb_type.h"
#include	"kb_value.h"
#include	"kb_location.h"
#include	"kb_callback.h"
#include	"kb_prompt.h"
#include	"kb_pyscript.h"
#include	"kb_dictionary.h"
#include	"kb_prompt.h"

#include	"tk_messagebox.h"

#include	"tkc_pydebugbase.h"

extern	QString 	getPythonString	(PyObject *) ;
extern	KBCallback	*kbCallback	;


/*  kbPYMessageBox							*/
/*		: Show simple message box				*/
/*  self	: PyObject *	:					*/
/*  args	: PyObject *	: Arguments				*/
/*  (returns)	: PyObject *	: 					*/

static	PyObject *kbPYMessageBox
	(	 PyObject	*,
		 PyObject	*args
	)
{
	cchar	*message	= 0 ;
	cchar	*caption	= 0 ;

	if (!PyArg_ParseTuple (args, _C("s|s"), &message, &caption))
		return	0	;

	if (caption == 0) caption = "Database" ;

	TKMessageBox::information
	(	0,
		message,
		caption
	)	;

	Py_INCREF(Py_None) ;
	return 	  Py_None  ;
}


/*  kbPYQueryBox: Show simple yes/no query box				*/
/*  self	: PyObject *	:					*/
/*  args	: PyObject *	: Arguments				*/
/*  (returns)	: PyObject *	: True if yes				*/

static	PyObject *kbPYQueryBox
	(	 PyObject	*,
		 PyObject	*args
	)
{
	cchar	*message	= 0 ;
	cchar	*caption	= 0 ;

	if (!PyArg_ParseTuple (args, _C("s|s"), &message, &caption))
		return	0	;

	if (caption == 0) caption = "Database" ;

	bool	yes	= TKMessageBox::questionYesNo
			  (	0,
				message,
				caption
			  )
			  == TKMessageBox::Yes ;

	return	PyInt_FromLong (yes) ;
}


/*  kbPYPromptBox								*/
/*		: Show simple prompt					*/
/*  self	: PyObject *	:					*/
/*  args	: PyObject *	: Arguments				*/
/*  (returns)	: PyObject *	: 					*/

static	PyObject *kbPYPromptBox
	(	 PyObject	*,
		 PyObject	*args
	)
{
	cchar	*message	= 0 ;
	cchar	*caption	= 0 ;
	cchar	*defval		= 0 ;

	QString	value		;

	if (!PyArg_ParseTuple (args, _C("s|ss"), &message, &defval, &caption))
		return	0	;

	if (caption == 0) caption = "Database" ;
	value	= defval	;

	if (!doPrompt (caption, message, value))
	{	Py_INCREF(Py_None) ;
		return	  Py_None  ;
	}

	return	PyString_FromString(_C(value) == 0 ? "" : _C(value)) ;
}

/*  kbPYChoiceBox							*/
/*		: Show simple prompt					*/
/*  self	: PyObject *	:					*/
/*  args	: PyObject *	: Arguments				*/
/*  (returns)	: PyObject *	: 					*/

static	PyObject *kbPYChoiceBox
	(	 PyObject	*,
		 PyObject	*args
	)
{
	cchar		*message	= 0 ;
	PyObject	*choices	= 0 ;
	cchar		*caption	= 0 ;
	QStringList	cList		;
	QString		resVal		;

	if (!PyArg_ParseTuple (args, _C("sO!|s"), &message, &PyList_Type, &choices, &caption))
		return	0	;

	if (caption == 0) caption = "Database" ;

	for (int idx = 0 ; idx < PyList_Size(choices) ; idx += 1)
		cList.append (getPythonString(PyList_GetItem(choices, idx))) ;

	KBChoiceDlg dDlg (caption, message, cList, resVal) ;
	if (!dDlg.exec())
	{	Py_INCREF(Py_None) ;
		return	  Py_None  ;
	}

	return	PyString_FromString(_C(resVal)) ; 
}


/*  kbPYLogscript							*/
/*		: Log message to script log window			*/
/*  self	: PyObject *	:					*/
/*  args	: PyObject *	: Arguments				*/
/*  (returns)	: PyObject *	: 					*/

static	PyObject *kbPYLogscript
	(	 PyObject	*,
		 PyObject	*args
	)
{
	cchar	*text	= 0 ;

	if (!PyArg_ParseTuple (args, _C("s"), &text))
		return	0	;

	if (text != 0)
		kbCallback->logScript (text, true) ;

	Py_INCREF(Py_None) ;
	return	  Py_None  ;
}

/*  kbPYGetDictEntry							*/
/*		: Get dictionary entry					*/
/*  self	: PyObject *	:					*/
/*  args	: PyObject *	: Arguments				*/
/*  (returns)	: PyObject *	: 					*/

static	PyObject *kbPYGetDictEntry
	(	 PyObject	*,
		 PyObject	*args
	)
{
	cchar		*dict	= 0 ;
	cchar		*elem	= 0 ;
	cchar		*attr	= 0 ;
	KBDictionary	*dictionary ;	

	static	QDict<KBDictionary>	dictionaries ;

	if (!PyArg_ParseTuple (args, _C("sss"), &dict, &elem, &attr))
		return	0	;

	if ((dictionary = dictionaries.find (dict)) == 0)
	{
		dictionary = new KBDictionary (dict) ;
		dictionaries.insert (dict, dictionary) ;
	}

	QString	text	= dictionary->getAttrDescription (elem, attr) ;
	return	PyString_FromString (text.isEmpty() ? "" : _C (text)) ;
}


/*  kbPyDebug								*/
/* 		: Enter debugger					*/
/*  self	: PyObject *	:					*/
/*  args	: PyObject *	: Arguments				*/
/*  (returns)	: PyObject *	: 					*/

static	PyObject *kbPyDebug
	(	 PyObject	*,
		 PyObject	*args
	)
{
	TKCPyDebugBase	*deb	= TKCPyDebugBase::self() ;

	if (deb == 0)
	{	
		Py_INCREF(Py_None) ;
		return 	  Py_None  ;
	}

	cchar	*msg	= 0	;
	PyArg_ParseTuple (args, _C("s"), &msg) ;

	return	deb->debugHook (PyEval_GetFrame(), msg) ;
}

static	PyMethodDef	basicFuncs[] =
{
{	_C("messageBox"),	kbPYMessageBox,		METH_VARARGS,	0	},
{	_C("queryBox"),		kbPYQueryBox,		METH_VARARGS,	0	},
{	_C("promptBox"),	kbPYPromptBox,		METH_VARARGS,	0	},
{	_C("choiceBox"),	kbPYChoiceBox,		METH_VARARGS,	0	},
{	_C("logscript"),	kbPYLogscript,		METH_VARARGS,	0	},
{	_C("getDictEntry"),	kbPYGetDictEntry,	METH_VARARGS,	0	},
{	_C("debug"),		kbPyDebug,		METH_VARARGS,	0	},
{	0,			0,			0,		0	}
}	;

void	initPYBasic ()
{
	Py_InitModule (_C("RekallMain"), basicFuncs) ;
}


#ifdef	__DOCS
  <class name="RekallMain" title="RekallMain functions">
    <method name="messageBox" comment="Show a simple popup message box">
      <return type="void" comment=""/>
      <arg type="string" comment="Message to display" opt="No"/>
      <arg type="string" comment="Popup box caption" opt="Yes"/>
    </method>
    <method name="queryBox" comment="Show a simple Yes/No query box">
      <return type="void" comment=""/>
      <arg type="string" comment="Message to display" opt="No"/>
      <arg type="string" comment="Popup box caption" opt="Yes"/>
    </method>
    <method name="promptBox" comment="Show a simple prompt box">
      <return type="void" comment=""/>
      <arg type="string" comment="Message to display" opt="No"/>
      <arg type="string" comment="Default value" opt="Yes"/>
      <arg type="string" comment="Popup box caption" opt="Yes"/>
    </method>
    <method name="choiceBox" comment="Show a popup with selection combobox">
      <return type="void" comment=""/>
      <arg type="string" comment="Message to display" opt="No"/>
      <arg type="list" comment="List of entries for combobox" opt="Yes"/>
      <arg type="string" comment="Popup box caption" opt="Yes"/>
    </method>
    <method name="logscript" comment="Write message to script log window">
      <return type="void" comment=""/>
      <arg type="string" comment="Message to be written" opt="No"/>
    </method>
  </class>
#endif	// __DOCS
