/***************************************************************************
    file	         : tkc_pytracelist.cpp
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#include	"tkc_pytracelist.h"

/*  TKCPyTraceItem							*/
/*  TKCPyTraceItem							*/
/*		: Constructor for function entry tracepoint		*/
/*  parent	: QListView *	  : Parent list view			*/
/*  key		: const QString & : Key text				*/
/*  code	: TKCPyValue *	  : Code object				*/
/*  _enabled	: bool		  : Enabled as breakpoint		*/
/*  (returns)	: TKCPyTraceItem  :					*/

TKCPyTraceItem::TKCPyTraceItem
	(	QListView	*parent,
		const QString	&key,
		TKCPyValue	*code,
		bool		_enabled
	)
	:
	TKCPyValueItem	(parent, key, code),
	online		(false),
	lineno		(0)
{
	count	= 0	 ;
	setText	(2, "" ) ;
	setText (4, "0") ;

	enable	(_enabled) ;
}

/*  TKCPyTraceItem							*/
/*  TKCPyTraceItem							*/
/*		: Constructor for line tracepoint			*/
/*  parent	: QListView *	 : Parent list view			*/
/*  key		: const QString & : Key text				*/
/*  module	: TKCPyValue *	 : Module object			*/
/*  _enabled	: bool		 : Enabled as breakpoint		*/
/*  lineno	: uint		 : Line number				*/
/*  (returns)	: TKCPyTraceItem :					*/

TKCPyTraceItem::TKCPyTraceItem
	(	QListView	*parent,
		const QString	&key,
		TKCPyValue	*code,
		bool		_enabled,
		uint		lineno
	)
	:
	TKCPyValueItem	(parent, key, code),
	online		(true),
	lineno		(lineno)
{
	count	= 0	 ;
	setText (2, QString("%1").arg(lineno)) ;
	setText (4, "0") ;

	enable	(_enabled) ;
}
